/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.sMPEssentialsV1.features;

import me.poggercity.sMPEssentialsV1.Feature;
import me.poggercity.sMPEssentialsV1.SMPEssentialsV1;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BanShieldsFeature
implements Feature,
Listener {
    private final SMPEssentialsV1 plugin;
    private boolean enabled;

    public BanShieldsFeature(SMPEssentialsV1 plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        this.loadConfig();
        if (this.enabled) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
            this.plugin.getLogger().info("Ban Shields: Enabled");
        } else {
            this.plugin.getLogger().info("Ban Shields: Disabled");
        }
    }

    @Override
    public void reload() {
        this.loadConfig();
        if (this.enabled) {
            this.plugin.getLogger().info("Ban Shields reloaded: Enabled");
        } else {
            this.plugin.getLogger().info("Ban Shields reloaded: Disabled");
        }
    }

    @Override
    public void disable() {
    }

    @Override
    public String getName() {
        return "Ban Shields";
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private void loadConfig() {
        this.enabled = this.plugin.getConfig().getBoolean("features.BAN_SHIELDS", false);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.enabled) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack offHand = player.getInventory().getItemInOffHand();
        if (mainHand != null && mainHand.getType() == Material.SHIELD || offHand != null && offHand.getType() == Material.SHIELD) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        if (!this.enabled) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (player.isBlocking()) {
            player.setCooldown(Material.SHIELD, 0);
        }
    }
}

