/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.sMPEssentialsV1.features;

import me.poggercity.sMPEssentialsV1.Feature;
import me.poggercity.sMPEssentialsV1.SMPEssentialsV1;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DisableEnderPearlsFeature
implements Feature,
Listener {
    private final SMPEssentialsV1 plugin;
    private boolean enabled;

    public DisableEnderPearlsFeature(SMPEssentialsV1 plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        this.loadConfig();
        if (this.enabled) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
            this.plugin.getLogger().info("Disable Ender Pearls: Enabled");
        } else {
            this.plugin.getLogger().info("Disable Ender Pearls: Disabled");
        }
    }

    @Override
    public void reload() {
        this.loadConfig();
        if (this.enabled) {
            this.plugin.getLogger().info("Disable Ender Pearls reloaded: Enabled");
        } else {
            this.plugin.getLogger().info("Disable Ender Pearls reloaded: Disabled");
        }
    }

    @Override
    public void disable() {
    }

    @Override
    public String getName() {
        return "Disable Ender Pearls";
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private void loadConfig() {
        this.enabled = this.plugin.getConfig().getBoolean("features.DISABLE_ENDER_PEARLS", false);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.enabled) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = event.getItem();
        if (item != null && item.getType() == Material.ENDER_PEARL) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEnderPearlThrow(ProjectileLaunchEvent event) {
        EnderPearl pearl;
        if (!this.enabled) {
            return;
        }
        if (event.getEntity() instanceof EnderPearl && (pearl = (EnderPearl)event.getEntity()).getShooter() instanceof Player) {
            Player player = (Player)pearl.getShooter();
            event.setCancelled(true);
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.ENDER_PEARL, 1)});
        }
    }
}

