/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.sMPEssentialsV1.features;

import java.util.HashMap;
import java.util.Map;
import me.poggercity.sMPEssentialsV1.Feature;
import me.poggercity.sMPEssentialsV1.SMPEssentialsV1;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class EnchantmentLimitFeature
implements Feature,
Listener {
    private final SMPEssentialsV1 plugin;
    private Map<Enchantment, Integer> enchantmentLimits = new HashMap<Enchantment, Integer>();
    private boolean enabled;
    private BukkitTask checkTask;

    public EnchantmentLimitFeature(SMPEssentialsV1 plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        this.loadConfig();
        if (this.enabled) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
            this.checkTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::checkAllPlayersItems, 40L, 40L);
            this.plugin.getLogger().info("Enchantment Limits: Loaded " + this.enchantmentLimits.size() + " enchantment limits");
        } else {
            this.plugin.getLogger().info("Enchantment Limits: Disabled");
        }
    }

    @Override
    public void reload() {
        if (this.checkTask != null) {
            this.checkTask.cancel();
        }
        this.loadConfig();
        if (this.enabled) {
            this.checkTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::checkAllPlayersItems, 40L, 40L);
            this.checkAllPlayersItems();
            this.plugin.getLogger().info("Enchantment Limits reloaded: " + this.enchantmentLimits.size() + " limits active");
        }
    }

    @Override
    public void disable() {
        if (this.checkTask != null) {
            this.checkTask.cancel();
        }
    }

    @Override
    public String getName() {
        return "Enchantment Limits";
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private void loadConfig() {
        this.enchantmentLimits.clear();
        if (!this.plugin.getConfig().contains("features.enchant-limits")) {
            this.enabled = false;
            return;
        }
        ConfigurationSection enchantLimitsSection = this.plugin.getConfig().getConfigurationSection("features.enchant-limits");
        if (enchantLimitsSection == null || enchantLimitsSection.getKeys(false).isEmpty()) {
            this.enabled = false;
            return;
        }
        this.enabled = true;
        for (String enchantName : enchantLimitsSection.getKeys(false)) {
            try {
                Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchantName.toLowerCase()));
                if (enchantment == null) {
                    enchantment = Enchantment.getByName((String)enchantName.toUpperCase());
                }
                if (enchantment != null) {
                    int limit = enchantLimitsSection.getInt(enchantName);
                    if (limit <= 0) continue;
                    this.enchantmentLimits.put(enchantment, limit);
                    this.plugin.getLogger().info("Enchantment Limit: " + enchantName + " -> " + limit);
                    continue;
                }
                this.plugin.getLogger().warning("Invalid enchantment in config: " + enchantName);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error loading enchantment limit for: " + enchantName);
            }
        }
        if (this.enchantmentLimits.isEmpty()) {
            this.enabled = false;
        }
    }

    private void checkAllPlayersItems() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.checkPlayerItems(player);
        }
    }

    private void checkPlayerItems(Player player) {
        ItemStack offHand;
        ItemStack mainHand;
        boolean modified = false;
        ItemStack[] armor = player.getInventory().getArmorContents();
        for (int i = 0; i < armor.length; ++i) {
            if (armor[i] == null || !this.limitEnchantments(armor[i])) continue;
            modified = true;
        }
        if (modified) {
            player.getInventory().setArmorContents(armor);
            modified = false;
        }
        if ((mainHand = player.getInventory().getItemInMainHand()) != null) {
            this.limitEnchantments(mainHand);
        }
        if ((offHand = player.getInventory().getItemInOffHand()) != null) {
            this.limitEnchantments(offHand);
        }
    }

    private void checkPlayerInventory(Player player) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null) continue;
            this.limitEnchantments(item);
        }
    }

    private boolean limitEnchantments(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (!meta.hasEnchants()) {
            return false;
        }
        boolean modified = false;
        for (Map.Entry<Enchantment, Integer> limitEntry : this.enchantmentLimits.entrySet()) {
            int currentLevel;
            Enchantment enchantment = limitEntry.getKey();
            int limit = limitEntry.getValue();
            if (!meta.hasEnchant(enchantment) || (currentLevel = meta.getEnchantLevel(enchantment)) <= limit) continue;
            meta.removeEnchant(enchantment);
            if (limit > 0) {
                meta.addEnchant(enchantment, limit, true);
            }
            modified = true;
        }
        if (modified) {
            item.setItemMeta(meta);
        }
        return modified;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.enabled) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.checkPlayerItems(event.getPlayer());
                this.checkPlayerInventory(event.getPlayer());
            }, 20L);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (this.enabled && event.getWhoClicked() instanceof Player) {
            Player player = (Player)event.getWhoClicked();
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                ItemStack cursorItem;
                this.checkPlayerItems(player);
                ItemStack clickedItem = event.getCurrentItem();
                if (clickedItem != null) {
                    this.limitEnchantments(clickedItem);
                }
                if ((cursorItem = event.getCursor()) != null) {
                    this.limitEnchantments(cursorItem);
                }
            }, 1L);
        }
    }

    @EventHandler
    public void onItemHeld(PlayerItemHeldEvent event) {
        if (this.enabled) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.checkPlayerItems(event.getPlayer()), 1L);
        }
    }
}

