/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.sMPEssentialsV1.features;

import me.poggercity.sMPEssentialsV1.Feature;
import me.poggercity.sMPEssentialsV1.SMPEssentialsV1;
import org.bukkit.Bukkit;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ProtectionLimitFeature
implements Feature,
Listener {
    private final SMPEssentialsV1 plugin;
    private int protectionLimit;
    private boolean enabled;
    private BukkitTask checkTask;

    public ProtectionLimitFeature(SMPEssentialsV1 plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        this.loadConfig();
        if (this.enabled) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
            this.checkTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::checkAllPlayersArmor, 20L, 20L);
            this.plugin.getLogger().info("Protection Limit: " + this.protectionLimit);
        }
    }

    @Override
    public void reload() {
        if (this.checkTask != null) {
            this.checkTask.cancel();
        }
        this.loadConfig();
        if (this.enabled) {
            this.checkTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::checkAllPlayersArmor, 20L, 20L);
            this.checkAllPlayersArmor();
            this.plugin.getLogger().info("Protection Limit reloaded: " + this.protectionLimit);
        }
    }

    @Override
    public void disable() {
        if (this.checkTask != null) {
            this.checkTask.cancel();
        }
    }

    @Override
    public String getName() {
        return "Protection Limit";
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private void loadConfig() {
        this.protectionLimit = this.plugin.getConfig().getInt("features.PROT_LIMIT", -1);
        if (this.protectionLimit <= 0) {
            this.enabled = false;
            return;
        }
        this.enabled = true;
        if (this.protectionLimit > 4) {
            this.protectionLimit = 4;
        }
    }

    private void checkAllPlayersArmor() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.checkPlayerArmor(player);
        }
    }

    private void checkPlayerArmor(Player player) {
        ItemStack[] armor = player.getInventory().getArmorContents();
        boolean modified = false;
        for (int i = 0; i < armor.length; ++i) {
            if (armor[i] == null || !this.limitProtection(armor[i])) continue;
            modified = true;
        }
        if (modified) {
            player.getInventory().setArmorContents(armor);
        }
    }

    private boolean limitProtection(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (!meta.hasEnchant(Enchantment.PROTECTION)) {
            return false;
        }
        int currentLevel = meta.getEnchantLevel(Enchantment.PROTECTION);
        if (currentLevel > this.protectionLimit) {
            meta.removeEnchant(Enchantment.PROTECTION);
            meta.addEnchant(Enchantment.PROTECTION, this.protectionLimit, true);
            item.setItemMeta(meta);
            return true;
        }
        return false;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.enabled) {
            this.checkPlayerArmor(event.getPlayer());
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (this.enabled && event.getWhoClicked() instanceof Player) {
            Player player = (Player)event.getWhoClicked();
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.checkPlayerArmor(player), 1L);
        }
    }

    @EventHandler
    public void onItemHeld(PlayerItemHeldEvent event) {
        if (this.enabled) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.checkPlayerArmor(event.getPlayer()), 1L);
        }
    }
}

