/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.sMPEssentialsV1.features;

import me.poggercity.sMPEssentialsV1.Feature;
import me.poggercity.sMPEssentialsV1.SMPEssentialsV1;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class SharpnessLimitFeature
implements Feature,
Listener {
    private final SMPEssentialsV1 plugin;
    private int sharpnessLimit;
    private boolean enabled;
    private BukkitTask checkTask;

    public SharpnessLimitFeature(SMPEssentialsV1 plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        this.loadConfig();
        if (this.enabled) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
            this.checkTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::checkAllPlayersWeapons, 20L, 20L);
            this.plugin.getLogger().info("Sharpness Limit: " + this.sharpnessLimit);
        }
    }

    @Override
    public void reload() {
        if (this.checkTask != null) {
            this.checkTask.cancel();
        }
        this.loadConfig();
        if (this.enabled) {
            this.checkTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::checkAllPlayersWeapons, 20L, 20L);
            this.checkAllPlayersWeapons();
            this.plugin.getLogger().info("Sharpness Limit reloaded: " + this.sharpnessLimit);
        }
    }

    @Override
    public void disable() {
        if (this.checkTask != null) {
            this.checkTask.cancel();
        }
    }

    @Override
    public String getName() {
        return "Sharpness Limit";
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private void loadConfig() {
        this.sharpnessLimit = this.plugin.getConfig().getInt("features.SHARPNESS_LIMIT", -1);
        if (this.sharpnessLimit <= 0) {
            this.enabled = false;
            return;
        }
        this.enabled = true;
        if (this.sharpnessLimit > 5) {
            this.sharpnessLimit = 5;
        }
    }

    private void checkAllPlayersWeapons() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.checkPlayerWeapons(player);
        }
    }

    private void checkPlayerWeapons(Player player) {
        ItemStack offHand;
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        if (mainHand != null && this.isWeapon(mainHand)) {
            this.limitSharpness(mainHand);
        }
        if ((offHand = player.getInventory().getItemInOffHand()) != null && this.isWeapon(offHand)) {
            this.limitSharpness(offHand);
        }
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || !this.isWeapon(item)) continue;
            this.limitSharpness(item);
        }
    }

    private boolean isWeapon(ItemStack item) {
        Material type = item.getType();
        return type == Material.WOODEN_SWORD || type == Material.STONE_SWORD || type == Material.IRON_SWORD || type == Material.GOLDEN_SWORD || type == Material.DIAMOND_SWORD || type == Material.NETHERITE_SWORD || type == Material.WOODEN_AXE || type == Material.STONE_AXE || type == Material.IRON_AXE || type == Material.GOLDEN_AXE || type == Material.DIAMOND_AXE || type == Material.NETHERITE_AXE;
    }

    private boolean limitSharpness(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (!meta.hasEnchant(Enchantment.SHARPNESS)) {
            return false;
        }
        int currentLevel = meta.getEnchantLevel(Enchantment.SHARPNESS);
        if (currentLevel > this.sharpnessLimit) {
            meta.removeEnchant(Enchantment.SHARPNESS);
            meta.addEnchant(Enchantment.SHARPNESS, this.sharpnessLimit, true);
            item.setItemMeta(meta);
            return true;
        }
        return false;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.enabled) {
            this.checkPlayerWeapons(event.getPlayer());
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (this.enabled && event.getWhoClicked() instanceof Player) {
            Player player = (Player)event.getWhoClicked();
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.checkPlayerWeapons(player), 1L);
        }
    }

    @EventHandler
    public void onItemHeld(PlayerItemHeldEvent event) {
        if (this.enabled) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.checkPlayerWeapons(event.getPlayer()), 1L);
        }
    }
}

