/*
 * Decompiled with CFR 0.152.
 */
package info.partonetrain.trains_tweaks;

import com.mojang.brigadier.CommandDispatcher;
import info.partonetrain.trains_tweaks.AllFeatures;
import info.partonetrain.trains_tweaks.CommonClass;
import info.partonetrain.trains_tweaks.IEarlyConfigReader;
import info.partonetrain.trains_tweaks.ModFeature;
import info.partonetrain.trains_tweaks.feature.attackspeed.AttackSpeedEffects;
import info.partonetrain.trains_tweaks.feature.attackspeed.AttackSpeedFeature;
import info.partonetrain.trains_tweaks.feature.kritz.KritzEffects;
import info.partonetrain.trains_tweaks.feature.kritz.KritzFeature;
import info.partonetrain.trains_tweaks.feature.utilitycommands.KillNonPlayersCommand;
import info.partonetrain.trains_tweaks.feature.utilitycommands.UtilityCommandsFeature;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.PercentageAttribute;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="trains_tweaks")
public class TrainsTweaksNeoForge {
    public static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((Registry)BuiltInRegistries.MOB_EFFECT, (String)"trains_tweaks");
    private static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((Registry)BuiltInRegistries.ATTRIBUTE, (String)"trains_tweaks");
    DeferredHolder<Attribute, Attribute> meleeAttributeHolder;
    DeferredHolder<Attribute, Attribute> rangedAttributeHolder;

    public TrainsTweaksNeoForge(ModContainer container, IEventBus eventBus) {
        for (ModFeature mf : AllFeatures.features) {
            IEarlyConfigReader earlyConfigReader;
            if (mf instanceof IEarlyConfigReader && !(earlyConfigReader = (IEarlyConfigReader)((Object)mf)).isExtraEarly()) {
                earlyConfigReader.readConfigsEarly();
            }
            if (mf.configSpec != null) {
                container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)mf.configSpec, mf.getConfigPath());
            }
            if (mf.getFeatureName().equals("AttackSpeed") && AttackSpeedFeature.enabled && AttackSpeedFeature.addEffects) {
                AttackSpeedFeature.DEXTERITY = MOB_EFFECTS.register("dexterity", () -> AttackSpeedEffects.d);
                AttackSpeedFeature.CLUMSY = MOB_EFFECTS.register("clumsy", () -> AttackSpeedEffects.c);
            }
            if (mf.getFeatureName().equals("Kritz")) {
                if (KritzFeature.enabled && KritzFeature.addAttributes) {
                    this.meleeAttributeHolder = ATTRIBUTES.register("melee_crit_chance", () -> new PercentageAttribute("attribute.name.trains_tweaks.melee_crit_chance", KritzFeature.kritChance, 0.0, 1.0).setSyncable(true));
                    KritzFeature.MELEE_CRIT_CHANCE = this.meleeAttributeHolder.getDelegate();
                    this.rangedAttributeHolder = ATTRIBUTES.register("ranged_crit_chance", () -> new PercentageAttribute("attribute.name.trains_tweaks.ranged_crit_chance", KritzFeature.kritChance, 0.0, 1.0).setSyncable(true));
                    KritzFeature.RANGED_CRIT_CHANCE = this.rangedAttributeHolder.getDelegate();
                    eventBus.addListener(this::registerAttributesToPlayer);
                }
                if (KritzFeature.enabled && KritzFeature.addEffects) {
                    KritzFeature.MELEE_CRIT_EFFECT = MOB_EFFECTS.register("melee_fury", () -> KritzEffects.me);
                    KritzFeature.RANGED_CRIT_EFFECT = MOB_EFFECTS.register("ranged_fury", () -> KritzEffects.re);
                }
            }
            if (!mf.getFeatureName().equals("UtilityCommands") || !UtilityCommandsFeature.enabled) continue;
            NeoForge.EVENT_BUS.addListener(this::registerCommands);
        }
        MOB_EFFECTS.register(eventBus);
        ATTRIBUTES.register(eventBus);
        CommonClass.init();
    }

    public void registerCommands(RegisterCommandsEvent event) {
        if (UtilityCommandsFeature.addKillNonPlayer) {
            KillNonPlayersCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }
    }

    public void registerAttributesToPlayer(EntityAttributeModificationEvent event) {
        event.add(EntityType.PLAYER, KritzFeature.MELEE_CRIT_CHANCE);
        event.add(EntityType.PLAYER, KritzFeature.RANGED_CRIT_CHANCE);
    }
}

