/*
 * Decompiled with CFR 0.152.
 */
package info.partonetrain.trains_tweaks.feature.attackspeed;

import info.partonetrain.trains_tweaks.Constants;
import info.partonetrain.trains_tweaks.feature.attackspeed.AttackSpeedFeature;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class AttackSpeedEffects {
    public static final MobEffect d = new AttackSpeedEffect(MobEffectCategory.BENEFICIAL, 14270531).addAttributeModifier(Attributes.ATTACK_SPEED, Constants.DEXTERITY_EFFECT_ID, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    public static final MobEffect c = new AttackSpeedEffect(MobEffectCategory.HARMFUL, 4866583).addAttributeModifier(Attributes.ATTACK_SPEED, Constants.CLUMSY_EFFECT_ID, -0.1, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);

    public static void fabricInit() {
        AttackSpeedFeature.DEXTERITY = Registry.registerForHolder((Registry)BuiltInRegistries.MOB_EFFECT, (ResourceLocation)Constants.DEXTERITY_EFFECT_ID, (Object)d);
        AttackSpeedFeature.CLUMSY = Registry.registerForHolder((Registry)BuiltInRegistries.MOB_EFFECT, (ResourceLocation)Constants.CLUMSY_EFFECT_ID, (Object)c);
    }

    public static class AttackSpeedEffect
    extends MobEffect {
        protected AttackSpeedEffect(MobEffectCategory category, int color) {
            super(category, color);
        }

        public void onEffectAdded(@NotNull LivingEntity entity, int amplifier) {
            super.onEffectAdded(entity, amplifier);
            if (entity instanceof Player) {
                Player p = (Player)entity;
                p.resetAttackStrengthTicker();
            }
        }
    }
}

