/*
 * Decompiled with CFR 0.152.
 */
package info.partonetrain.trains_tweaks.feature.attackspeed;

import info.partonetrain.trains_tweaks.CommonClass;
import info.partonetrain.trains_tweaks.Constants;
import info.partonetrain.trains_tweaks.IEarlyConfigReader;
import info.partonetrain.trains_tweaks.ModFeature;
import info.partonetrain.trains_tweaks.feature.attackspeed.AttackSpeedFeatureConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class AttackSpeedFeature
extends ModFeature
implements IEarlyConfigReader {
    public static boolean configRead = false;
    public static boolean enabled = false;
    public static boolean fixEffects = true;
    public static boolean addEffects = true;
    public static double fixedEffectModifier = 0.25;
    public static Holder<MobEffect> DEXTERITY;
    public static Holder<MobEffect> CLUMSY;

    public AttackSpeedFeature() {
        super("AttackSpeed", AttackSpeedFeatureConfig.SPEC);
    }

    @Override
    public void readConfigsEarly() {
        String configFileLoc = System.getProperty("user.dir") + "\\config\\trains_tweaks\\" + this.getFeatureName() + ".toml";
        Path configFilePath = Paths.get(configFileLoc, new String[0]);
        try {
            List<String> allLines = Files.readAllLines(configFilePath);
            if (!allLines.contains("\"Attack Speed tweaks\" = true")) {
                enabled = false;
                configRead = true;
                return;
            }
            enabled = true;
            fixEffects = allLines.contains("\"Fix Effects\" = true");
            addEffects = allLines.contains("\"Add Effects\" = true");
            Pattern pattern = Pattern.compile("\"Fixed Effects Modifier\" *= *([-+]?[0-9]*.?[0-9]+)");
            for (String line : allLines) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.matches()) continue;
                double value = Double.parseDouble(matcher.group(1));
                Constants.LOG.info("Haste will add " + value + " to " + Attributes.BLOCK_BREAK_SPEED.getRegisteredName());
                fixedEffectModifier = value;
            }
            configRead = true;
        }
        catch (IOException e) {
            CommonClass.printEarlyConfigError(this.featureName, e);
            configRead = true;
        }
    }

    @Override
    public boolean isExtraEarly() {
        return true;
    }
}

