/*
 * Decompiled with CFR 0.152.
 */
package info.partonetrain.trains_tweaks.feature.attackspeed;

import info.partonetrain.trains_tweaks.Constants;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.neoforge.common.ModConfigSpec;

public class AttackSpeedFeatureConfig {
    public static ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static ModConfigSpec.BooleanValue ENABLED;
    public static ModConfigSpec.BooleanValue FIX_EFFECTS;
    public static ModConfigSpec.BooleanValue ADD_EFFECTS;
    public static ModConfigSpec.DoubleValue FIXED_EFFECT_MODIFIER;
    public static ModConfigSpec.BooleanValue ADD_HASTE_TO_CONDUIT;
    public static ModConfigSpec.IntValue ELDER_GUARDIAN_FATIGUE_AMPLIFIER;

    public static void registerConfig(ModConfigSpec.Builder builder) {
        ENABLED = builder.comment("Whether or not to enable attack speed tweaks").define("Attack Speed tweaks", false);
        FIX_EFFECTS = builder.comment("If enabled, Haste and Mining Fatigue no longer modify the " + Attributes.ATTACK_SPEED.getRegisteredName() + " attribute").comment("Instead, they properly affect the " + Attributes.BLOCK_BREAK_SPEED.getRegisteredName() + " attribute").comment("The mining speed calculation will no longer consider the presence of these effects, only the attribute they modify").comment("However, as a side effect, Conduit Power will no longer grant a Haste-like effect").comment("This makes Haste and Mining Fatigue behave similar to Bedrock Edition").define("Fix Effects", true);
        FIXED_EFFECT_MODIFIER = builder.comment("If Fix Effects is enabled, this is the value of the Haste attribute modifier").comment("Mining Fatigue's modifier will have the negative version of this value").defineInRange("Fixed Effects Modifier", 0.2, 0.01, 1.0);
        ADD_EFFECTS = builder.comment("If enabled, the effects " + String.valueOf(Constants.DEXTERITY_EFFECT_ID) + " and " + String.valueOf(Constants.CLUMSY_EFFECT_ID) + " will be registered").comment("They increase/decrease the " + Attributes.ATTACK_SPEED.getRegisteredName() + " attribute by 0.1").comment("There is no potion defined for these, and they are simply substitutes for the attack speed part of Haste/Fatigue that is disabled by Fix Effects").comment("However, this option does not explicitly require Fix Effects to be enabled").define("Add Effects", true);
        ADD_HASTE_TO_CONDUIT = builder.comment("If enabled, Haste will be granted by the Conduit in addition to Conduit Power").comment("This makes up for the fact that Conduit Power no longer influences block break speed if Fix Effects is enabled").define("Haste from Conduit", false);
        ELDER_GUARDIAN_FATIGUE_AMPLIFIER = builder.comment("If > 2, Elder Guardians will grant Mining Fatigue with this amplifier").comment("This makes up for a potentially weaker Mining Fatigue effect from Fixed Effects being enabled").comment("This is recommended to be set to at least 3 if Fix Effects is enabled and Fix Effects Modifier is set to 0.2").defineInRange("Elder Guardian Fatigue Amplifier", 2, 2, 9);
    }

    static {
        AttackSpeedFeatureConfig.registerConfig(builder);
        SPEC = builder.build();
    }
}

