/*
 * Decompiled with CFR 0.152.
 */
package info.partonetrain.trains_tweaks.feature.horse;

import info.partonetrain.trains_tweaks.CommonClass;
import info.partonetrain.trains_tweaks.Constants;
import info.partonetrain.trains_tweaks.IEarlyConfigReader;
import info.partonetrain.trains_tweaks.ModFeature;
import info.partonetrain.trains_tweaks.feature.horse.HorseFeatureConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HorseFeature
extends ModFeature
implements IEarlyConfigReader {
    public static boolean configRead = false;
    public static boolean enabled = false;
    public static double healthBuff = -1.0;
    public static double speedBuff = -1.0;
    public static double jumpBuff = -1.0;

    public HorseFeature() {
        super("Horse", HorseFeatureConfig.SPEC);
    }

    @Override
    public void readConfigsEarly() {
        String configFileLoc = System.getProperty("user.dir") + "\\config\\trains_tweaks\\" + this.getFeatureName() + ".toml";
        Path configFilePath = Paths.get(configFileLoc, new String[0]);
        try {
            List<String> allLines = Files.readAllLines(configFilePath);
            if (!allLines.contains("\"Horse Tweaks\" = true")) {
                enabled = false;
                configRead = true;
                return;
            }
            enabled = true;
            Pattern healthPattern = Pattern.compile("\"Horse Health Minimum\" *= *([-+]?[0-9]*.?[0-9]+)");
            Pattern speedPattern = Pattern.compile("\"Horse Speed Minimum\" *= *([-+]?[0-9]*.?[0-9]+)");
            Pattern jumpPattern = Pattern.compile("\"Horse Jump Minimum\" *= *([-+]?[0-9]*.?[0-9]+)");
            for (String line : allLines) {
                double value;
                Matcher matcher;
                if (healthBuff == -1.0 && (matcher = healthPattern.matcher(line)).matches() && (value = Double.parseDouble(matcher.group(1))) != 15.0) {
                    Constants.LOG.info("Horse health will be at least " + value);
                    healthBuff = value;
                }
                if (speedBuff == -1.0 && (matcher = speedPattern.matcher(line)).matches() && (value = Double.parseDouble(matcher.group(1))) != 0.1125) {
                    Constants.LOG.info("Horse speed will be at least " + value);
                    speedBuff = value;
                }
                if (jumpBuff != -1.0 || !(matcher = jumpPattern.matcher(line)).matches() || (value = Double.parseDouble(matcher.group(1))) == 0.4) continue;
                Constants.LOG.info("Horse jump will be at least " + value);
                jumpBuff = value;
            }
            configRead = true;
        }
        catch (IOException e) {
            CommonClass.printEarlyConfigError(this.featureName, e);
            configRead = true;
        }
    }
}

