/*
 * Decompiled with CFR 0.152.
 */
package info.partonetrain.trains_tweaks.feature.kritz;

import info.partonetrain.trains_tweaks.CommonClass;
import info.partonetrain.trains_tweaks.IEarlyConfigReader;
import info.partonetrain.trains_tweaks.ModFeature;
import info.partonetrain.trains_tweaks.feature.kritz.KritzFeatureConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;

public class KritzFeature
extends ModFeature
implements IEarlyConfigReader {
    public static boolean configRead = false;
    public static boolean enabled = false;
    public static boolean addAttributes = true;
    public static boolean addEffects = true;
    public static double kritChance = -0.0625;
    public static double kritMultipler = -1.5;
    public static Holder<Attribute> MELEE_CRIT_CHANCE;
    public static Holder<Attribute> RANGED_CRIT_CHANCE;
    public static Holder<MobEffect> MELEE_CRIT_EFFECT;
    public static Holder<MobEffect> RANGED_CRIT_EFFECT;

    public KritzFeature() {
        super("Kritz", KritzFeatureConfig.SPEC);
        this.incompatibleMods.add("zenith_attributes");
        this.incompatibleMods.add("apothic_attributes");
    }

    @Override
    public void readConfigsEarly() {
        if (this.isIncompatibleLoaded()) {
            enabled = false;
            return;
        }
        String configFileLoc = System.getProperty("user.dir") + "\\config\\trains_tweaks\\" + this.getFeatureName() + ".toml";
        Path configFilePath = Paths.get(configFileLoc, new String[0]);
        try {
            List<String> allLines = Files.readAllLines(configFilePath);
            if (!allLines.contains("\"Critical Hit tweaks\" = true")) {
                enabled = false;
                return;
            }
            enabled = true;
            if (allLines.contains("\"Add Attributes\" = true")) {
                addAttributes = true;
                addEffects = allLines.contains("\"Add Effects\" = true");
            } else {
                addAttributes = false;
                addEffects = false;
            }
            Pattern chancePattern = Pattern.compile("\"Crit Chance\" *= *([-+]?[0-9]*.?[0-9]+)");
            Pattern multPattern = Pattern.compile("\"Crit Multiplier\" *= *([-+]?[0-9]*.?[0-9]+)");
            for (String line : allLines) {
                Matcher matcher;
                if (kritChance == -0.0625 && (matcher = chancePattern.matcher(line)).matches()) {
                    kritChance = Double.parseDouble(matcher.group(1));
                }
                if (kritMultipler != -1.5 || !(matcher = multPattern.matcher(line)).matches()) continue;
                kritMultipler = Double.parseDouble(matcher.group(1));
            }
            configRead = true;
        }
        catch (IOException e) {
            CommonClass.printEarlyConfigError(this.featureName, e);
            configRead = true;
        }
    }
}

