/*
 * Decompiled with CFR 0.152.
 */
package info.partonetrain.trains_tweaks.feature.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import info.partonetrain.trains_tweaks.Constants;
import info.partonetrain.trains_tweaks.feature.loot.LootFeature;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class EnchantCurseFunction
extends LootItemConditionalFunction {
    public static final MapCodec<EnchantCurseFunction> CODEC = RecordCodecBuilder.mapCodec(recordCodecBuilder -> EnchantCurseFunction.commonFields((RecordCodecBuilder.Instance)recordCodecBuilder).and(recordCodecBuilder.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ENCHANTMENT).optionalFieldOf("options").forGetter(thisCurseFunction -> thisCurseFunction.options), (App)Codec.BOOL.optionalFieldOf("only_compatible", (Object)Boolean.TRUE).forGetter(thisCurseFunction -> thisCurseFunction.onlyCompatible))).apply((Applicative)recordCodecBuilder, EnchantCurseFunction::new));
    private final Optional<HolderSet<Enchantment>> options;
    private final boolean onlyCompatible;

    EnchantCurseFunction(List<LootItemCondition> conditons, Optional<HolderSet<Enchantment>> options, boolean onlyCompatible) {
        super(conditons);
        this.options = options;
        this.onlyCompatible = onlyCompatible;
    }

    @NotNull
    public LootItemFunctionType<EnchantCurseFunction> getType() {
        return LootFeature.ENCHANT_CURSE_FUNCTION;
    }

    @NotNull
    public ItemStack run(ItemStack stack, LootContext context) {
        RandomSource randomsource = context.getRandom();
        boolean isBook = stack.is(Items.BOOK);
        boolean checkCompatibility = !isBook && this.onlyCompatible;
        Stream<Holder> stream = this.options.map(HolderSet::stream).orElseGet(() -> context.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT).holders().map(Function.identity())).filter(enchantmentHolder -> (!checkCompatibility || ((Enchantment)enchantmentHolder.value()).canEnchant(stack)) && enchantmentHolder.is(EnchantmentTags.CURSE));
        List<Holder> list = stream.toList();
        Optional optional = Util.getRandomSafe(list, (RandomSource)randomsource);
        if (optional.isEmpty()) {
            Constants.LOG.warn("Couldn't find a compatible curse enchantment for {}", (Object)stack);
            return stack;
        }
        return EnchantCurseFunction.enchantItem(stack, (Holder<Enchantment>)((Holder)optional.get()));
    }

    private static ItemStack enchantItem(ItemStack itemStack, Holder<Enchantment> enchantment) {
        int level = ((Enchantment)enchantment.value()).getMaxLevel();
        if (itemStack.is(Items.BOOK)) {
            itemStack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        }
        itemStack.enchant(enchantment, level);
        return itemStack;
    }
}

