/*
 * Decompiled with CFR 0.152.
 */
package info.partonetrain.trains_tweaks.feature.rarity;

import info.partonetrain.trains_tweaks.Constants;
import info.partonetrain.trains_tweaks.ModFeature;
import info.partonetrain.trains_tweaks.feature.rarity.RarityFeatureConfig;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;

public class RarityFeature
extends ModFeature {
    public RarityFeature() {
        super("Rarity", RarityFeatureConfig.SPEC);
        this.incompatibleMods.add("customrarity");
    }

    public static Rarity setTaggedRarity(ItemStack stack) {
        boolean preventEnchantments = RarityFeatureConfig.PREVENT_ENCHANTMENT_ALTERING.getAsBoolean();
        if (RarityFeatureConfig.DATA_TAG_ENABLED.getAsBoolean()) {
            if (stack.is(Constants.COMMON_TAG) && (!((Rarity)stack.get(DataComponents.RARITY)).equals((Object)Rarity.COMMON) || stack.isEnchanted() && !((Rarity)stack.get(DataComponents.RARITY)).equals((Object)Rarity.UNCOMMON))) {
                stack.set(DataComponents.RARITY, (Object)(!preventEnchantments && stack.isEnchanted() ? Rarity.UNCOMMON : Rarity.COMMON));
            } else if (stack.is(Constants.UNCOMMON_TAG) && (!((Rarity)stack.get(DataComponents.RARITY)).equals((Object)Rarity.UNCOMMON) || stack.isEnchanted() && !((Rarity)stack.get(DataComponents.RARITY)).equals((Object)Rarity.RARE))) {
                stack.set(DataComponents.RARITY, (Object)(!preventEnchantments && stack.isEnchanted() ? Rarity.RARE : Rarity.UNCOMMON));
            } else if (stack.is(Constants.RARE_TAG) && (!((Rarity)stack.get(DataComponents.RARITY)).equals((Object)Rarity.RARE) || stack.isEnchanted() && !((Rarity)stack.get(DataComponents.RARITY)).equals((Object)Rarity.EPIC))) {
                stack.set(DataComponents.RARITY, (Object)(!preventEnchantments && stack.isEnchanted() ? Rarity.EPIC : Rarity.RARE));
            } else if (stack.is(Constants.EPIC_TAG) && !((Rarity)stack.get(DataComponents.RARITY)).equals((Object)Rarity.EPIC)) {
                stack.set(DataComponents.RARITY, (Object)Rarity.EPIC);
            } else if (RarityFeatureConfig.RESTORE_DEFAULT.getAsBoolean() && !((Rarity)stack.getItem().getDefaultInstance().get(DataComponents.RARITY)).equals(stack.get(DataComponents.RARITY))) {
                stack.set(DataComponents.RARITY, (Object)((Rarity)stack.getItem().getDefaultInstance().get(DataComponents.RARITY)));
            }
        }
        return (Rarity)stack.getOrDefault(DataComponents.RARITY, (Object)Rarity.COMMON);
    }

    public static Rarity getTaggedRarity(ItemStack stack) {
        if (RarityFeatureConfig.ITEMSTACK_CHECK_TAG.getAsBoolean()) {
            if (stack.is(Constants.COMMON_TAG)) {
                return Rarity.COMMON;
            }
            if (stack.is(Constants.UNCOMMON_TAG)) {
                return Rarity.UNCOMMON;
            }
            if (stack.is(Constants.RARE_TAG)) {
                return Rarity.RARE;
            }
            if (stack.is(Constants.EPIC_TAG)) {
                return Rarity.EPIC;
            }
        }
        return Rarity.COMMON;
    }
}

