/*
 * Decompiled with CFR 0.152.
 */
package info.partonetrain.trains_tweaks.feature.spawnswith;

import com.google.common.collect.Maps;
import info.partonetrain.trains_tweaks.CommonClass;
import info.partonetrain.trains_tweaks.Constants;
import info.partonetrain.trains_tweaks.ModFeature;
import info.partonetrain.trains_tweaks.feature.spawnswith.EquipmentTableType;
import info.partonetrain.trains_tweaks.feature.spawnswith.SpawnsWithFeatureConfig;
import info.partonetrain.trains_tweaks.mixin.SpawnsWith_MobInvoker;
import info.partonetrain.trains_tweaks.platform.Services;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class SpawnsWithFeature
extends ModFeature {
    public static final String TABLE_PREFIX = "trains_tweaks:equipment/";
    public static final String MAINHAND_SUFFIX = "_main_hand";
    public static final String OFFHAND_SUFFIX = "_off_hand";
    public static final String ARMOR_SUFFIX = "_armor";
    public static final String CHECKED_TAG = "trains_tweaks:spawnswith_checked";

    public SpawnsWithFeature() {
        super("SpawnsWith", SpawnsWithFeatureConfig.SPEC);
    }

    public static void clearVanillaGear(Mob mob, EquipmentTableType equipmentTableType) {
        if (equipmentTableType == EquipmentTableType.MAIN_HAND) {
            mob.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        } else if (equipmentTableType == EquipmentTableType.OFF_HAND) {
            mob.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
        } else if (equipmentTableType == EquipmentTableType.ARMOR) {
            mob.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
            mob.setItemSlot(EquipmentSlot.CHEST, ItemStack.EMPTY);
            mob.setItemSlot(EquipmentSlot.LEGS, ItemStack.EMPTY);
            mob.setItemSlot(EquipmentSlot.FEET, ItemStack.EMPTY);
        }
    }

    public static void rollGenericTable(LivingEntity livingEntity) {
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            boolean wasSilent = mob.isSilent();
            mob.setSilent(true);
            Level level = mob.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (Services.PLATFORM.canRollSpawnsWithTables(mob)) {
                    SpawnsWithFeature.clearVanillaGear(mob, EquipmentTableType.ARMOR);
                    LootParams.Builder builder = new LootParams.Builder(serverLevel);
                    builder.withLuck(serverLevel.getCurrentDifficultyAt(mob.getOnPos()).getEffectiveDifficulty()).withParameter(LootContextParams.ORIGIN, (Object)mob.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)mob);
                    LootParams paramsWithLuck = builder.create(LootContextParamSets.EQUIPMENT);
                    mob.equip(Constants.GENERIC_EQUIPMENT_LOOT_TABLE, paramsWithLuck, SpawnsWithFeature.createDropChanceMap());
                }
            }
            mob.setSilent(wasSilent);
        } else {
            Constants.LOG.error("rollGenericTable: " + livingEntity.getType().toString() + " was not a Mob");
        }
    }

    public static void rollSpecificTable(LivingEntity livingEntity, Map<EquipmentTableType, ResourceKey<LootTable>> map) {
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            boolean wasSilent = mob.isSilent();
            mob.setSilent(true);
            Level level = mob.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (Services.PLATFORM.canRollSpawnsWithTables(mob)) {
                    ItemStack first;
                    ObjectArrayList rolledStacks;
                    LootParams.Builder builder = new LootParams.Builder(serverLevel);
                    builder.withLuck(serverLevel.getCurrentDifficultyAt(mob.getOnPos()).getEffectiveDifficulty()).withParameter(LootContextParams.ORIGIN, (Object)mob.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)mob);
                    LootParams paramsWithLuck = builder.create(LootContextParamSets.EQUIPMENT);
                    if (map.get((Object)EquipmentTableType.MAIN_HAND) != null) {
                        SpawnsWithFeature.clearVanillaGear(mob, EquipmentTableType.MAIN_HAND);
                        LootTable mainhandTable = serverLevel.getServer().reloadableRegistries().getLootTable(map.get((Object)EquipmentTableType.MAIN_HAND));
                        rolledStacks = mainhandTable.getRandomItems(paramsWithLuck);
                        if (!rolledStacks.isEmpty()) {
                            first = (ItemStack)rolledStacks.getFirst();
                            mob.setItemSlot(EquipmentSlot.MAINHAND, first);
                            mob.setDropChance(EquipmentSlot.MAINHAND, (float)SpawnsWithFeatureConfig.EQUIPMENT_TABLE_DROP_CHANCE.getAsDouble());
                        }
                    }
                    if (map.get((Object)EquipmentTableType.OFF_HAND) != null) {
                        SpawnsWithFeature.clearVanillaGear(mob, EquipmentTableType.OFF_HAND);
                        LootTable offhandTable = serverLevel.getServer().reloadableRegistries().getLootTable(map.get((Object)EquipmentTableType.OFF_HAND));
                        rolledStacks = offhandTable.getRandomItems(paramsWithLuck);
                        if (!rolledStacks.isEmpty()) {
                            first = (ItemStack)rolledStacks.getFirst();
                            mob.setItemSlot(EquipmentSlot.OFFHAND, first);
                            mob.setDropChance(EquipmentSlot.OFFHAND, (float)SpawnsWithFeatureConfig.EQUIPMENT_TABLE_DROP_CHANCE.getAsDouble());
                        }
                    }
                    if (map.get((Object)EquipmentTableType.ARMOR) != null) {
                        SpawnsWithFeature.clearVanillaGear(mob, EquipmentTableType.ARMOR);
                        mob.equip(map.get((Object)EquipmentTableType.ARMOR), paramsWithLuck, SpawnsWithFeature.createDropChanceMap());
                    }
                    mob.setSilent(wasSilent);
                }
            }
        } else {
            Constants.LOG.error("rollSpecificTable: " + livingEntity.getType().toString() + " was not a Mob");
        }
    }

    public static void populateEnchantments(LivingEntity livingEntity) {
        Mob mob;
        Level level;
        if (livingEntity instanceof Mob && (level = (mob = (Mob)livingEntity).level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ((SpawnsWith_MobInvoker)mob).invokePopulateDefaultEquipmentEnchantments((ServerLevelAccessor)serverLevel, mob.getRandom(), mob.level().getCurrentDifficultyAt(mob.getOnPos()));
        }
    }

    public static ResourceLocation getEntityResourceLocation(LivingEntity livingEntity) {
        return BuiltInRegistries.ENTITY_TYPE.getKey((Object)livingEntity.getType());
    }

    public static boolean isEntityChecked(LivingEntity livingEntity) {
        return livingEntity.getTags().contains(CHECKED_TAG);
    }

    public static boolean markEntityChecked(LivingEntity livingEntity) {
        return livingEntity.addTag(CHECKED_TAG);
    }

    public static Map<EquipmentTableType, ResourceKey<LootTable>> findLootTables(ServerLevel serverLevel, LivingEntity livingEntity) {
        return SpawnsWithFeature.findLootTables(serverLevel, SpawnsWithFeature.getEntityResourceLocation(livingEntity));
    }

    public static Map<EquipmentTableType, ResourceKey<LootTable>> findLootTables(ServerLevel serverLevel, ResourceLocation entityKey) {
        HashMap<EquipmentTableType, ResourceKey<LootTable>> map = new HashMap<EquipmentTableType, ResourceKey<LootTable>>();
        Map<EquipmentTableType, ResourceLocation> rlsToFind = SpawnsWithFeature.makeLootTableIds(entityKey);
        for (EquipmentTableType ett : EquipmentTableType.values()) {
            ResourceKey tableKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)rlsToFind.get((Object)ett));
            if (serverLevel.getServer().reloadableRegistries().getLootTable(tableKey) == LootTable.EMPTY) {
                map.put(ett, null);
                continue;
            }
            map.put(ett, (ResourceKey<LootTable>)tableKey);
            CommonClass.printInDev("found " + rlsToFind.get((Object)ett).toString());
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public static Map<EquipmentTableType, ResourceLocation> makeLootTableIds(ResourceLocation entityKey) {
        HashMap<EquipmentTableType, ResourceLocation> map = new HashMap<EquipmentTableType, ResourceLocation>();
        String namespace = entityKey.getNamespace();
        String path = entityKey.getPath();
        ResourceLocation mainhand = ResourceLocation.parse((String)(TABLE_PREFIX + namespace + "/" + path + MAINHAND_SUFFIX));
        ResourceLocation offhand = ResourceLocation.parse((String)(TABLE_PREFIX + namespace + "/" + path + OFFHAND_SUFFIX));
        ResourceLocation armor = ResourceLocation.parse((String)(TABLE_PREFIX + namespace + "/" + path + ARMOR_SUFFIX));
        map.put(EquipmentTableType.MAIN_HAND, mainhand);
        map.put(EquipmentTableType.OFF_HAND, offhand);
        map.put(EquipmentTableType.ARMOR, armor);
        return map;
    }

    public static Map<EquipmentSlot, Float> createDropChanceMap() {
        float dropChance = (float)SpawnsWithFeatureConfig.EQUIPMENT_TABLE_DROP_CHANCE.getAsDouble();
        HashMap map = Maps.newHashMap();
        for (EquipmentSlot e : EquipmentSlot.values()) {
            if (e.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            map.put(e, Float.valueOf(dropChance));
        }
        return map;
    }
}

