/*
 * Decompiled with CFR 0.152.
 */
package info.partonetrain.trains_tweaks.feature.trigger;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import info.partonetrain.trains_tweaks.feature.trigger.TriggerFeature;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class DayTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player) {
        this.trigger(player, instance -> instance.matches(player));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<MinMaxBounds.Ints> days) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(p_337396_ -> p_337396_.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("day").forGetter(TriggerInstance::days)).apply((Applicative)p_337396_, TriggerInstance::new));

        public static Criterion<TriggerInstance> checkDay(EntityPredicate.Builder player) {
            return TriggerFeature.DAY_TRIGGER.createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)player)), Optional.empty()));
        }

        public boolean matches(ServerPlayer player) {
            long time = player.level().getDayTime();
            int dayNumber = (int)(time / 24000L);
            if (this.days.isPresent()) {
                return this.days.get().matches(dayNumber);
            }
            return false;
        }
    }
}

