/*
 * Decompiled with CFR 0.152.
 */
package info.partonetrain.trains_tweaks.feature.trigger;

import info.partonetrain.trains_tweaks.CommonClass;
import info.partonetrain.trains_tweaks.IEarlyConfigReader;
import info.partonetrain.trains_tweaks.ModFeature;
import info.partonetrain.trains_tweaks.feature.trigger.DayTrigger;
import info.partonetrain.trains_tweaks.feature.trigger.GameTimeTrigger;
import info.partonetrain.trains_tweaks.feature.trigger.TriggerFeatureConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class TriggerFeature
extends ModFeature
implements IEarlyConfigReader {
    public static boolean enabled = false;
    public static boolean gameTimeEnabled = false;
    public static boolean dayEnabled = false;
    public static GameTimeTrigger GAME_TIME_TRIGGER;
    public static DayTrigger DAY_TRIGGER;

    public TriggerFeature() {
        super("Trigger", TriggerFeatureConfig.SPEC);
    }

    @Override
    public void readConfigsEarly() {
        String configFileLoc = System.getProperty("user.dir") + "\\config\\trains_tweaks\\" + this.getFeatureName() + ".toml";
        Path configFilePath = Paths.get(configFileLoc, new String[0]);
        try {
            List<String> allLines = Files.readAllLines(configFilePath);
            if (!allLines.contains("\"Trigger tweaks\" = true")) {
                enabled = false;
                return;
            }
            enabled = true;
            gameTimeEnabled = allLines.contains("\"Game Time trigger\" = true");
            dayEnabled = allLines.contains("\"Day trigger\" = true");
        }
        catch (IOException e) {
            CommonClass.printEarlyConfigError(this.featureName, e);
        }
    }

    @Override
    public boolean isExtraEarly() {
        return true;
    }
}

