/*
 * Decompiled with CFR 0.152.
 */
package info.partonetrain.trains_tweaks.feature.utilitycommands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import info.partonetrain.trains_tweaks.Constants;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class KillNonPlayersCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"kill_non_players").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).executes(commandContext -> KillNonPlayersCommand.killNonPlayers((CommandSourceStack)commandContext.getSource())));
    }

    private static int killNonPlayers(CommandSourceStack source) {
        try {
            Iterable targets = source.getLevel().getAllEntities();
            int count = 0;
            for (Entity e : targets) {
                if (e == null || e instanceof Player) continue;
                e.remove(Entity.RemovalReason.DISCARDED);
                ++count;
            }
            int finalCount = count;
            source.sendSuccess(() -> Component.translatable((String)"commands.trains_tweaks.kill_non_players.success", (Object[])new Object[]{finalCount}), true);
            return count;
        }
        catch (Exception e) {
            Constants.LOG.info(e.getMessage());
            return -1;
        }
    }
}

