/*
 * Decompiled with CFR 0.152.
 */
package info.partonetrain.trains_tweaks.feature.utilitycommands;

import info.partonetrain.trains_tweaks.CommonClass;
import info.partonetrain.trains_tweaks.IEarlyConfigReader;
import info.partonetrain.trains_tweaks.ModFeature;
import info.partonetrain.trains_tweaks.feature.utilitycommands.UtilityCommandsFeatureConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class UtilityCommandsFeature
extends ModFeature
implements IEarlyConfigReader {
    public static boolean enabled = false;
    public static boolean vanillaDebugCommands = false;
    public static boolean addKillNonPlayer = false;

    public UtilityCommandsFeature() {
        super("UtilityCommands", UtilityCommandsFeatureConfig.SPEC);
    }

    @Override
    public void readConfigsEarly() {
        String configFileLoc = System.getProperty("user.dir") + "\\config\\trains_tweaks\\" + this.getFeatureName() + ".toml";
        Path configFilePath = Paths.get(configFileLoc, new String[0]);
        try {
            List<String> allLines = Files.readAllLines(configFilePath);
            if (!allLines.contains("\"Utility Commands\" = true")) {
                enabled = false;
                return;
            }
            enabled = true;
            addKillNonPlayer = allLines.contains("\"Kill Non Players\" = true");
            vanillaDebugCommands = allLines.contains("\"Vanilla Debug Commands\" = true");
        }
        catch (IOException e) {
            CommonClass.printEarlyConfigError(this.featureName, e);
        }
    }
}

