/*
 * Decompiled with CFR 0.152.
 */
package info.partonetrain.trains_tweaks.feature.zzz;

import info.partonetrain.trains_tweaks.ModFeature;
import info.partonetrain.trains_tweaks.feature.zzz.ZzzFeatureConfig;
import java.util.Collection;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;

public class ZzzFeature
extends ModFeature {
    public ZzzFeature() {
        super("Zzz", ZzzFeatureConfig.SPEC);
    }

    public static void healPlayers(List<ServerPlayer> players) {
        for (ServerPlayer sp : players) {
            sp.setHealth(sp.getMaxHealth());
        }
    }

    public static void removeDebuffs(List<ServerPlayer> players) {
        for (ServerPlayer sp : players) {
            Collection effects = sp.getActiveEffects();
            for (MobEffectInstance mei : effects) {
                if (((MobEffect)mei.getEffect().value()).getCategory() != MobEffectCategory.HARMFUL || mei.isInfiniteDuration()) continue;
                sp.removeEffect(mei.getEffect());
            }
        }
    }

    public static int getSleepNewColor(int sleepTimer) {
        float sleepPercentage = (float)sleepTimer / (float)ZzzFeatureConfig.SLEEP_REQUIRED_TICKS.getAsInt();
        if (sleepPercentage > 1.0f) {
            sleepPercentage = 1.0f - (float)(sleepTimer - ZzzFeatureConfig.SLEEP_REQUIRED_TICKS.getAsInt()) / 10.0f;
        }
        int newColor = (int)(220.0f * sleepPercentage) << 24 | 0x101020;
        if (ZzzFeatureConfig.CLIENT_SLEEP_COLOR.getAsInt() != 0) {
            newColor += ZzzFeatureConfig.CLIENT_SLEEP_COLOR.getAsInt();
        }
        return newColor;
    }
}

