/*
 * Decompiled with CFR 0.152.
 */
package info.partonetrain.trains_tweaks.mixin;

import info.partonetrain.trains_tweaks.AllFeatures;
import info.partonetrain.trains_tweaks.Constants;
import info.partonetrain.trains_tweaks.feature.mobdrops.MobDropsFeatureConfig;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class MobDrops_LivingEntityMixin {
    @Inject(method={"createWitherRose"}, at={@At(value="HEAD")}, cancellable=true)
    public void trains_tweaks$createWitherRose(LivingEntity entitySource, CallbackInfo ci) {
        if (entitySource != null && !AllFeatures.MOB_DROPS_FEATURE.isIncompatibleLoaded() && MobDropsFeatureConfig.ENABLED.getAsBoolean() && MobDropsFeatureConfig.APPLY_TO_WITHER_ROSE.getAsBoolean()) {
            LivingEntity self = (LivingEntity)this;
            if (!self.level().isClientSide && entitySource.getType().is(Constants.ROSE_KILLER_TAG)) {
                DamageSource damageSource = self.getLastDamageSource();
                LootTable lootTable = self.level().getServer().reloadableRegistries().getLootTable(Constants.ROSE_LOOT_TABLE);
                LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)self.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)self).withParameter(LootContextParams.ORIGIN, (Object)self.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)entitySource).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)entitySource);
                LootParams lootparams = lootparams$builder.create(LootContextParamSets.ENTITY);
                ObjectArrayList items = lootTable.getRandomItems(lootparams, self.getLootTableSeed());
                for (ItemStack stack : items) {
                    ItemEntity itemEntity = self.spawnAtLocation(stack);
                }
            }
            ci.cancel();
        }
    }

    @Inject(method={"shouldDropLoot"}, at={@At(value="HEAD")}, cancellable=true)
    public void trains_tweaks$shouldDropLoot(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity self = (LivingEntity)this;
        if (!AllFeatures.MOB_DROPS_FEATURE.isIncompatibleLoaded() && MobDropsFeatureConfig.ENABLED.getAsBoolean() && MobDropsFeatureConfig.BABIES_DROP_LOOT.getAsBoolean() && self.isBaby()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"shouldDropExperience"}, at={@At(value="HEAD")}, cancellable=true)
    public void trains_tweaks$shouldDropExperience(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity self = (LivingEntity)this;
        if (!AllFeatures.MOB_DROPS_FEATURE.isIncompatibleLoaded() && MobDropsFeatureConfig.ENABLED.getAsBoolean() && MobDropsFeatureConfig.BABIES_DROP_EXPERIENCE.getAsBoolean() && self.isBaby()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"dropFromLootTable"}, at={@At(value="TAIL")})
    public void trains_tweaks$dropFromLootTable(DamageSource damageSource, boolean hitByPlayer, CallbackInfo ci) {
        if (!AllFeatures.MOB_DROPS_FEATURE.isIncompatibleLoaded() && MobDropsFeatureConfig.ENABLED.getAsBoolean() && MobDropsFeatureConfig.GENERIC_DROP_ENABLED.getAsBoolean()) {
            LivingEntity self = (LivingEntity)this;
            ServerLevel serverlevel = (ServerLevel)self.level();
            LootTable lootTable = serverlevel.getServer().reloadableRegistries().getLootTable(Constants.GENERIC_DROP_TABLE);
            float luck = damageSource.getEntity() instanceof Player ? ((Player)damageSource.getEntity()).getLuck() : 0.0f;
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)self.level()).withLuck(luck).withParameter(LootContextParams.THIS_ENTITY, (Object)self).withParameter(LootContextParams.ORIGIN, (Object)self.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)damageSource.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)damageSource.getDirectEntity());
            if (hitByPlayer && self.lastHurtByPlayer != null) {
                builder = builder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)self.lastHurtByPlayer).withLuck(self.lastHurtByPlayer.getLuck());
            }
            LootParams lootParams = builder.create(LootContextParamSets.ENTITY);
            lootTable.getRandomItems(lootParams, self.getLootTableSeed(), arg_0 -> ((LivingEntity)self).spawnAtLocation(arg_0));
        }
    }
}

