/*
 * Decompiled with CFR 0.152.
 */
package info.partonetrain.trains_tweaks.mixin;

import info.partonetrain.trains_tweaks.AllFeatures;
import info.partonetrain.trains_tweaks.Constants;
import info.partonetrain.trains_tweaks.feature.spawnswith.EquipmentTableType;
import info.partonetrain.trains_tweaks.feature.spawnswith.SpawnsWithFeature;
import info.partonetrain.trains_tweaks.feature.spawnswith.SpawnsWithFeatureConfig;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class SpawnsWith_LivingEntityMixin {
    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void trains_tweaks$tick(CallbackInfo ci) {
        if (!AllFeatures.SPAWNS_WITH_FEATURE.isIncompatibleLoaded() && SpawnsWithFeatureConfig.ENABLED.getAsBoolean()) {
            LivingEntity self = (LivingEntity)this;
            if (self.getType().is(Constants.SPAWNSWITH_IGNORES)) {
                return;
            }
            Level level = self.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!SpawnsWithFeature.isEntityChecked(self)) {
                    Map<EquipmentTableType, ResourceKey<LootTable>> map;
                    if (SpawnsWithFeatureConfig.GENERIC_MOB_TABLES.getAsBoolean() && self.getType().is(Constants.ROLLS_GENERIC_EQUIPMENT)) {
                        SpawnsWithFeature.rollGenericTable(self);
                    }
                    if (SpawnsWithFeatureConfig.SPECFIC_MOB_TABLES.getAsBoolean() && (map = SpawnsWithFeature.findLootTables(serverLevel, self)) != null) {
                        SpawnsWithFeature.rollSpecificTable(self, map);
                    }
                    if (SpawnsWithFeatureConfig.POPULATE_ENCHANTMENTS.getAsBoolean()) {
                        SpawnsWithFeature.populateEnchantments(self);
                    }
                    if (!SpawnsWithFeature.markEntityChecked(self)) {
                        Constants.LOG.error(self.getName().getString() + " had too many tags and could not be marked as trains_tweaks:spawnswith_checked");
                    }
                }
            }
        }
    }
}

