/*
 * Decompiled with CFR 0.152.
 */
package info.partonetrain.trains_tweaks.mixin;

import info.partonetrain.trains_tweaks.AllFeatures;
import info.partonetrain.trains_tweaks.feature.yeet.YeetFeatureConfig;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={FireChargeItem.class})
public class Yeet_FireChargeItemMixin
extends Item {
    public Yeet_FireChargeItemMixin(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        if (!AllFeatures.YEET_FEATURE.isIncompatibleLoaded() && YeetFeatureConfig.ENABLED.getAsBoolean() && YeetFeatureConfig.THROW_FIRE_CHARGES.getAsBoolean()) {
            ItemStack itemStack = player.getItemInHand(interactionHand);
            if (itemStack.is(Items.FIRE_CHARGE) && !level.isClientSide()) {
                Vec3 look = new Vec3(player.position().x, player.getEyePosition().y(), player.position().z);
                SmallFireball smallFireball = new SmallFireball(level, (LivingEntity)player, look);
                smallFireball.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.0f, 2.5f);
                smallFireball.setPos(player.getX(), player.getEyePosition().y(), player.getZ());
                level.addFreshEntity((Entity)smallFireball);
            }
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BLAZE_SHOOT, SoundSource.PLAYERS, 2.0f, (player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.2f + 1.0f);
            player.getCooldowns().addCooldown(Items.FIRE_CHARGE, YeetFeatureConfig.FIRE_CHARGES_COOLDOWN.getAsInt());
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            itemStack.consume(1, (LivingEntity)player);
            return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(interactionHand));
    }
}

