/*
 * Decompiled with CFR 0.152.
 */
package com.cdogsnappy.biggervaults.mixin;

import com.cdogsnappy.biggervaults.Config;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={FluidTankBlockEntity.class}, remap=false)
public abstract class TankMixin
extends BlockEntity {
    @Shadow
    protected boolean window;
    @Shadow
    protected int height;
    @Shadow
    protected int width;

    public TankMixin(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @ModifyReturnValue(method={"getMaxSize()I"}, at={@At(value="RETURN")})
    private static int modifyMaxWidth(int original) {
        return (Integer)Config.MAX_TANK_SIZE.get();
    }

    @ModifyReturnValue(method={"getMaxWidth()I"}, at={@At(value="RETURN")}, remap=false)
    private int maxWidth(int original) {
        return (Integer)Config.MAX_TANK_SIZE.get();
    }

    @Overwrite(remap=false)
    public void setWindows(boolean window) {
        this.window = window;
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.worldPosition.offset(xOffset, yOffset, zOffset);
                    BlockState blockState = this.level.getBlockState(pos);
                    if (!FluidTankBlock.isTank((BlockState)blockState)) continue;
                    FluidTankBlock.Shape shape = FluidTankBlock.Shape.PLAIN;
                    if (window) {
                        if (this.width == 1) {
                            shape = FluidTankBlock.Shape.WINDOW;
                        } else if (this.width == 2) {
                            shape = xOffset == 0 ? (zOffset == 0 ? FluidTankBlock.Shape.WINDOW_NW : FluidTankBlock.Shape.WINDOW_SW) : (zOffset == 0 ? FluidTankBlock.Shape.WINDOW_NE : FluidTankBlock.Shape.WINDOW_SE);
                        } else if (this.width % 2 == 1 && Math.abs(Math.abs(xOffset) - Math.abs(zOffset)) == this.width / 2) {
                            shape = FluidTankBlock.Shape.WINDOW;
                        }
                    }
                    this.level.setBlock(pos, (BlockState)blockState.setValue((Property)FluidTankBlock.SHAPE, (Comparable)shape), 22);
                    this.level.getChunkSource().getLightEngine().checkBlock(pos);
                }
            }
        }
    }
}

