/*
 * Decompiled with CFR 0.152.
 */
package cn.enaium.authenticate;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0003R\u001c\u0010\n\u001a\n \t*\u0004\u0018\u00010\b0\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR$\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcn/enaium/authenticate/Config;", "", "<init>", "()V", "", "load", "save", "reset", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "configFile", "Ljava/nio/file/Path;", "Lcn/enaium/authenticate/Config$Model;", "value", "model", "Lcn/enaium/authenticate/Config$Model;", "getModel", "()Lcn/enaium/authenticate/Config$Model;", "Model", "core"})
public final class Config {
    @NotNull
    public static final Config INSTANCE = new Config();
    private static final Path configFile;
    @NotNull
    private static Model model;

    private Config() {
    }

    @NotNull
    public final Model getModel() {
        return model;
    }

    public final void load() {
        Path path = configFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"configFile");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            try {
                Gson gson = new Gson();
                Path path3 = configFile;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"configFile");
                Object object = gson.fromJson(PathsKt.readText((Path)path3, (Charset)Charsets.UTF_8), Model.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                model = (Model)object;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.save();
        }
    }

    public final void save() {
        try {
            Path path = configFile;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"configFile");
            PathsKt.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
            Path path2 = configFile;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"configFile");
            String string = new GsonBuilder().setPrettyPrinting().create().toJson((Object)model);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            PathsKt.writeText((Path)path2, (CharSequence)string, (Charset)Charsets.UTF_8, (OpenOption[])new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void reset() {
        model = new Model(null, null, null, null, null, null, 63, null);
        this.save();
    }

    static {
        String string = System.getProperty("user.dir");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        Path path = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        configFile = path.resolve("config").resolve("Authenticate.json");
        model = new Model(null, null, null, null, null, null, 63, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\b\u0018\u00002\u00020\u0001BI\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\fJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\fJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\fJ\u0010\u0010\u0011\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\fJR\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\b\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\fR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001c\u001a\u0004\b\u001e\u0010\fR\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001f\u0010\fR\u0019\u0010\u0006\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001c\u001a\u0004\b \u0010\fR\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001c\u001a\u0004\b!\u0010\fR\u0017\u0010\b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001c\u001a\u0004\b\"\u0010\f\u00a8\u0006#"}, d2={"Lcn/enaium/authenticate/Config$Model;", "", "", "lang", "jdbcUrl", "username", "password", "salt", "ddlStatement", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "component1", "()Ljava/lang/String;", "component2", "component3", "component4", "component5", "component6", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lcn/enaium/authenticate/Config$Model;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getLang", "getJdbcUrl", "getUsername", "getPassword", "getSalt", "getDdlStatement", "core"})
    public static final class Model {
        @NotNull
        private final String lang;
        @NotNull
        private final String jdbcUrl;
        @Nullable
        private final String username;
        @Nullable
        private final String password;
        @Nullable
        private final String salt;
        @NotNull
        private final String ddlStatement;

        public Model(@NotNull String lang, @NotNull String jdbcUrl, @Nullable String username, @Nullable String password, @Nullable String salt, @NotNull String ddlStatement) {
            Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
            Intrinsics.checkNotNullParameter((Object)jdbcUrl, (String)"jdbcUrl");
            Intrinsics.checkNotNullParameter((Object)ddlStatement, (String)"ddlStatement");
            this.lang = lang;
            this.jdbcUrl = jdbcUrl;
            this.username = username;
            this.password = password;
            this.salt = salt;
            this.ddlStatement = ddlStatement;
        }

        public /* synthetic */ Model(String string, String string2, String string3, String string4, String string5, String string6, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "en_us";
            }
            if ((n & 2) != 0) {
                string2 = "jdbc:h2:file:./db/authenticate";
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                string4 = null;
            }
            if ((n & 0x10) != 0) {
                Base64.Encoder encoder = Base64.getEncoder();
                String string7 = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(...)");
                String string8 = string7;
                byte[] byArray = string8.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                string5 = encoder.encodeToString(byArray);
            }
            if ((n & 0x20) != 0) {
                string6 = "create table if not exists player_v0\n(\n    id uuid primary key not null,\n    created_time timestamp not null,\n    modified_time timestamp not null,\n    uuid uuid unique not null,\n    password varchar(255) not null,\n    banned timestamp\n);";
            }
            this(string, string2, string3, string4, string5, string6);
        }

        @NotNull
        public final String getLang() {
            return this.lang;
        }

        @NotNull
        public final String getJdbcUrl() {
            return this.jdbcUrl;
        }

        @Nullable
        public final String getUsername() {
            return this.username;
        }

        @Nullable
        public final String getPassword() {
            return this.password;
        }

        @Nullable
        public final String getSalt() {
            return this.salt;
        }

        @NotNull
        public final String getDdlStatement() {
            return this.ddlStatement;
        }

        @NotNull
        public final String component1() {
            return this.lang;
        }

        @NotNull
        public final String component2() {
            return this.jdbcUrl;
        }

        @Nullable
        public final String component3() {
            return this.username;
        }

        @Nullable
        public final String component4() {
            return this.password;
        }

        @Nullable
        public final String component5() {
            return this.salt;
        }

        @NotNull
        public final String component6() {
            return this.ddlStatement;
        }

        @NotNull
        public final Model copy(@NotNull String lang, @NotNull String jdbcUrl, @Nullable String username, @Nullable String password, @Nullable String salt, @NotNull String ddlStatement) {
            Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
            Intrinsics.checkNotNullParameter((Object)jdbcUrl, (String)"jdbcUrl");
            Intrinsics.checkNotNullParameter((Object)ddlStatement, (String)"ddlStatement");
            return new Model(lang, jdbcUrl, username, password, salt, ddlStatement);
        }

        public static /* synthetic */ Model copy$default(Model model, String string, String string2, String string3, String string4, String string5, String string6, int n, Object object) {
            if ((n & 1) != 0) {
                string = model.lang;
            }
            if ((n & 2) != 0) {
                string2 = model.jdbcUrl;
            }
            if ((n & 4) != 0) {
                string3 = model.username;
            }
            if ((n & 8) != 0) {
                string4 = model.password;
            }
            if ((n & 0x10) != 0) {
                string5 = model.salt;
            }
            if ((n & 0x20) != 0) {
                string6 = model.ddlStatement;
            }
            return model.copy(string, string2, string3, string4, string5, string6);
        }

        @NotNull
        public String toString() {
            return "Model(lang=" + this.lang + ", jdbcUrl=" + this.jdbcUrl + ", username=" + this.username + ", password=" + this.password + ", salt=" + this.salt + ", ddlStatement=" + this.ddlStatement + ')';
        }

        public int hashCode() {
            int result = this.lang.hashCode();
            result = result * 31 + this.jdbcUrl.hashCode();
            result = result * 31 + (this.username == null ? 0 : this.username.hashCode());
            result = result * 31 + (this.password == null ? 0 : this.password.hashCode());
            result = result * 31 + (this.salt == null ? 0 : this.salt.hashCode());
            result = result * 31 + this.ddlStatement.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Model)) {
                return false;
            }
            Model model = (Model)other;
            if (!Intrinsics.areEqual((Object)this.lang, (Object)model.lang)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.jdbcUrl, (Object)model.jdbcUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.username, (Object)model.username)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.password, (Object)model.password)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.salt, (Object)model.salt)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.ddlStatement, (Object)model.ddlStatement);
        }

        public Model() {
            this(null, null, null, null, null, null, 63, null);
        }
    }
}

