/*
 * Decompiled with CFR 0.152.
 */
package cn.enaium.authenticate;

import cn.enaium.authenticate.Config;
import cn.enaium.authenticate.event.Player;
import cn.enaium.authenticate.event.ServerCommandCallbacks;
import cn.enaium.authenticate.event.ServerPlayerCallbacks;
import cn.enaium.authenticate.event.impl.ServerCommandBanCallbackImpl;
import cn.enaium.authenticate.event.impl.ServerCommandLoginCallbackImpl;
import cn.enaium.authenticate.event.impl.ServerCommandLogoutCallbackImpl;
import cn.enaium.authenticate.event.impl.ServerCommandRegisterCallbackImpl;
import cn.enaium.authenticate.event.impl.ServerPlayerActionCallbackImpl;
import cn.enaium.authenticate.event.impl.ServerPlayerChatMessageCallbackImpl;
import cn.enaium.authenticate.event.impl.ServerPlayerConnectCallbackImpl;
import cn.enaium.authenticate.event.impl.ServerPlayerExecuteCallbackImpl;
import cn.enaium.authenticate.event.impl.ServerPlayerInteractBlockCallbackImpl;
import cn.enaium.authenticate.event.impl.ServerPlayerInteractEntityCallbackImpl;
import cn.enaium.authenticate.event.impl.ServerPlayerInteractItemCallbackImpl;
import cn.enaium.authenticate.event.impl.ServerPlayerInvisibleCallbackImpl;
import cn.enaium.authenticate.event.impl.ServerPlayerInvulnerableCallbackImpl;
import cn.enaium.authenticate.event.impl.ServerPlayerMoveCallbackImpl;
import cn.enaium.authenticate.event.impl.ServerPlayerTakeItemsCallbackCallbackImpl;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bJ\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\bJ\u000f\u0010\u000e\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u0003RT\u0010\u0012\u001aB\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00040\u0004 \u0011* \u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\u000f0\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcn/enaium/authenticate/Authenticate;", "", "<init>", "()V", "Lcn/enaium/authenticate/event/Player;", "player", "", "login", "(Lcn/enaium/authenticate/event/Player;)V", "logout", "", "isAuthenticated", "(Lcn/enaium/authenticate/event/Player;)Z", "refresh", "initializer", "Lcom/google/common/cache/Cache;", "", "kotlin.jvm.PlatformType", "auth", "Lcom/google/common/cache/Cache;", "core"})
public final class Authenticate {
    @NotNull
    public static final Authenticate INSTANCE = new Authenticate();
    private static final Cache<String, Player> auth = CacheBuilder.newBuilder().expireAfterWrite(Config.INSTANCE.getModel().getAuthExpire(), TimeUnit.MILLISECONDS).build();

    private Authenticate() {
    }

    public final void login(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        auth.put((Object)player.getKey(), (Object)player);
    }

    public final void logout(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        auth.invalidate((Object)player.getKey());
    }

    public final boolean isAuthenticated(@NotNull Player player) {
        boolean authed;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        boolean bl = authed = auth.getIfPresent((Object)player.getKey()) != null;
        if (authed) {
            this.refresh(player);
        }
        return authed;
    }

    public final void refresh(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.login(player);
    }

    @JvmStatic
    public static final void initializer() {
        System.out.println((Object)"Hello Authenticate world!");
        Config.INSTANCE.load();
        Runtime.getRuntime().addShutdownHook(new Thread(Authenticate::initializer$lambda$0));
        ServerPlayerCallbacks.ConnectCallback.Companion.getEVENT().register(ServerPlayerConnectCallbackImpl.INSTANCE);
        ServerPlayerCallbacks.ChatMessageCallback.Companion.getEVENT().register(ServerPlayerChatMessageCallbackImpl.INSTANCE);
        ServerPlayerCallbacks.ActionCallback.Companion.getEVENT().register(ServerPlayerActionCallbackImpl.INSTANCE);
        ServerPlayerCallbacks.MoveCallback.Companion.getEVENT().register(ServerPlayerMoveCallbackImpl.INSTANCE);
        ServerPlayerCallbacks.InteractBlockCallback.Companion.getEVENT().register(ServerPlayerInteractBlockCallbackImpl.INSTANCE);
        ServerPlayerCallbacks.InteractItemCallback.Companion.getEVENT().register(ServerPlayerInteractItemCallbackImpl.INSTANCE);
        ServerPlayerCallbacks.InteractEntityCallback.Companion.getEVENT().register(ServerPlayerInteractEntityCallbackImpl.INSTANCE);
        ServerPlayerCallbacks.ExecuteCallback.Companion.getEVENT().register(ServerPlayerExecuteCallbackImpl.INSTANCE);
        ServerPlayerCallbacks.TakeItemsCallback.Companion.getEVENT().register(ServerPlayerTakeItemsCallbackCallbackImpl.INSTANCE);
        ServerPlayerCallbacks.InvisibleCallback.Companion.getEVENT().register(ServerPlayerInvisibleCallbackImpl.INSTANCE);
        ServerPlayerCallbacks.InvulnerableCallback.Companion.getEVENT().register(ServerPlayerInvulnerableCallbackImpl.INSTANCE);
        ServerCommandCallbacks.RegisterCallback.Companion.getEVENT().register(ServerCommandRegisterCallbackImpl.INSTANCE);
        ServerCommandCallbacks.LoginCallback.Companion.getEVENT().register(ServerCommandLoginCallbackImpl.INSTANCE);
        ServerCommandCallbacks.LogoutCallback.Companion.getEVENT().register(ServerCommandLogoutCallbackImpl.INSTANCE);
        ServerCommandCallbacks.BanCallback.Companion.getEVENT().register(ServerCommandBanCallbackImpl.INSTANCE);
    }

    private static final void initializer$lambda$0() {
        Config.INSTANCE.save();
    }
}

