/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.sound;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.bunten.enderscape.network.ClientboundStructureChangedPayload;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7924;
import net.minecraft.class_8710;

public class StructureMusicHandler {
    private static final Map<class_3222, Integer> playerTimers = new HashMap<class_3222, Integer>();
    private static final Map<class_3222, class_2960> playerStructures = new HashMap<class_3222, class_2960>();
    public static final class_2960 NONE = class_2960.method_60656((String)"none");
    private static int structureChangeTimer = 0;

    private static void tryStructureChange(class_3222 player, class_2960 structure) {
        class_2960 currentStructure = playerStructures.get(player);
        if (currentStructure == null || !currentStructure.equals((Object)structure)) {
            playerStructures.put(player, structure);
            playerTimers.put(player, 1200);
        }
    }

    private static class_2960 getStructure(class_3218 level, class_3222 player) {
        if (level != null && player != null) {
            class_2378 registry = level.method_30349().method_30530(class_7924.field_41246);
            List structures = registry.method_10220().toList();
            for (class_3195 structure : structures) {
                if (structure == null || !level.method_27056().method_38854(class_2338.method_49638((class_2374)player.method_73189()), structure).method_16657()) continue;
                return registry.method_10221((Object)structure);
            }
        }
        return NONE;
    }

    private static void sendStructureToClient(class_3222 player, class_2960 structure) {
        if (player != null) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new ClientboundStructureChangedPayload(structure));
        }
    }

    private static void removeFromAll(class_3222 player) {
        playerStructures.remove(player);
        playerTimers.remove(player);
    }

    static {
        ServerWorldEvents.UNLOAD.register((server, level) -> {
            for (class_3222 player : level.method_18456()) {
                StructureMusicHandler.removeFromAll(player);
            }
        });
        ServerTickEvents.START_WORLD_TICK.register(level -> {
            if (!playerTimers.isEmpty()) {
                Iterator<Map.Entry<class_3222, Integer>> iterator = playerTimers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<class_3222, Integer> entry = iterator.next();
                    int newTimer = entry.getValue() - 1;
                    if (newTimer <= 0) {
                        class_3222 player = entry.getKey();
                        class_2960 queued = playerStructures.get(player);
                        if (player.method_5805() && StructureMusicHandler.getStructure(level, player).equals((Object)queued)) {
                            StructureMusicHandler.sendStructureToClient(player, queued);
                        }
                        iterator.remove();
                        continue;
                    }
                    entry.setValue(newTimer);
                }
            }
            if (structureChangeTimer-- <= 0) {
                for (class_3222 player : level.method_18766(class_1309::method_5805)) {
                    StructureMusicHandler.tryStructureChange(player, StructureMusicHandler.getStructure(level, player));
                }
                structureChangeTimer = 240;
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> StructureMusicHandler.removeFromAll(handler.method_32311()));
        ServerEntityEvents.ENTITY_UNLOAD.register((entity, level) -> {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                StructureMusicHandler.removeFromAll(player);
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            StructureMusicHandler.removeFromAll(oldPlayer);
            StructureMusicHandler.sendStructureToClient(newPlayer, NONE);
        });
    }
}

