/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.bunten.enderscape.block.BlisteredMagniaBlock;
import net.bunten.enderscape.block.DirectionalPlantBlock;
import net.bunten.enderscape.block.HasMagniaPolarity;
import net.bunten.enderscape.block.MagniaBlock;
import net.bunten.enderscape.block.MagniaSproutBlockEntity;
import net.bunten.enderscape.block.properties.DirectionSet;
import net.bunten.enderscape.block.properties.MagniaPolarity;
import net.bunten.enderscape.block.state.StateProperties;
import net.bunten.enderscape.registry.EnderscapeBlockEntities;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.bunten.enderscape.registry.tag.EnderscapeItemTags;
import net.bunten.enderscape.util.BlockUtil;
import net.bunten.enderscape.util.MagniaUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8235;
import org.jetbrains.annotations.Nullable;

public class MagniaSproutBlock
extends DirectionalPlantBlock
implements HasMagniaPolarity,
class_3737,
class_2343 {
    public static final class_2746 POWERED = StateProperties.field_12484;
    public static final class_2746 OVERHEATED = StateProperties.OVERHEATED;
    public static final class_2746 WATERLOGGED = StateProperties.field_12508;
    protected final MagniaPolarity polarity;

    public MagniaSproutBlock(MagniaPolarity polarity, class_4970.class_2251 settings) {
        super(DirectionSet.create().all(), settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)OVERHEATED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.polarity = polarity;
    }

    protected MapCodec<MagniaSproutBlock> method_53969() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)MagniaPolarity.CODEC.fieldOf("magnia_polarity").forGetter(sprout -> sprout.polarity), (App)MagniaSproutBlock.method_54096()).apply((Applicative)instance, MagniaSproutBlock::new));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MagniaSproutBlockEntity(pos, state);
    }

    @Nullable
    protected static <E extends class_2586, A extends class_2586> class_5558<A> createTickerHelper(class_2591<A> type1, class_2591<E> type2, class_5558<? super E> ticker) {
        return type2 == type1 ? ticker : null;
    }

    public static boolean isPowered(class_2680 state) {
        return state.method_26204() instanceof MagniaSproutBlock && (Boolean)state.method_11654((class_2769)POWERED) != false;
    }

    public static boolean isOverheated(class_2680 state) {
        return state.method_26204() instanceof MagniaSproutBlock && (Boolean)state.method_11654((class_2769)OVERHEATED) != false;
    }

    public static boolean shouldOverheat(class_1937 world, class_2338 origin) {
        for (class_2350 dir : class_2350.values()) {
            if (!world.method_8320(origin.method_10093(dir)).method_26164(EnderscapeBlockTags.OVERHEATS_MAGNIA_SPROUTS)) continue;
            return true;
        }
        return false;
    }

    public static boolean canPullEntities(class_2680 state) {
        return MagniaSproutBlock.isPowered(state) && !MagniaSproutBlock.isOverheated(state);
    }

    private boolean trySetPowered(class_2680 state, class_1937 level, class_2338 pos) {
        if (MagniaSproutBlock.shouldOverheat(level, pos) || !this.getNeighborSignal(state, (class_8235)level, pos, (class_2350)state.method_11654((class_2769)FACING))) {
            return false;
        }
        return this.setPowered(state, level, pos, true);
    }

    private boolean setPowered(class_2680 state, class_1937 level, class_2338 pos, boolean powered) {
        class_243 vec = class_243.method_24953((class_2382)pos);
        level.method_8652(pos, (class_2680)((class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered))).method_11657((class_2769)OVERHEATED, (Comparable)Boolean.valueOf(!powered && MagniaSproutBlock.isOverheated(state))), 3);
        level.method_43128(null, vec.field_1352, vec.field_1351, vec.field_1350, powered ? this.polarity.getPowerOnSound() : this.polarity.getPowerOffSound(), class_3419.field_15245, 1.0f, 1.0f);
        level.method_33596(null, (class_6880)(powered ? class_5712.field_28174 : class_5712.field_28175), pos);
        return true;
    }

    private void setOverheated(class_2680 state, class_1937 level, class_2338 pos, boolean value) {
        if (value) {
            class_243 vec = class_243.method_24953((class_2382)pos);
            class_2680 updatedState = state;
            if (MagniaSproutBlock.isPowered(state)) {
                updatedState = (class_2680)updatedState.method_28493((class_2769)POWERED);
                level.method_43128(null, vec.field_1352, vec.field_1351, vec.field_1350, this.polarity.getOverheatSound(), class_3419.field_15245, 1.0f, 1.0f);
            }
            level.method_8652(pos, (class_2680)updatedState.method_11657((class_2769)OVERHEATED, (Comparable)Boolean.valueOf(value)), 3);
            level.method_33596(null, (class_6880)class_5712.field_28733, pos);
        } else {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)OVERHEATED, (Comparable)Boolean.valueOf(value)), 3);
            level.method_33596(null, (class_6880)class_5712.field_28733, pos);
        }
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        return !level.method_8608() && MagniaSproutBlock.canPullEntities(state) ? MagniaSproutBlock.createTickerHelper(type, EnderscapeBlockEntities.MAGNIA_SPROUT, MagniaSproutBlockEntity::tick) : null;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, POWERED, OVERHEATED, WATERLOGGED});
    }

    @Override
    public boolean canPlantOn(class_2680 state, class_2680 floor, class_1922 level, class_2338 pos, class_2350 facing) {
        return floor.method_26206(level, pos, facing);
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return BlockUtil.createRotatedShape(3.0, 0.0, 3.0, 13.0, 13.0, 13.0, (class_2350)state.method_11654((class_2769)FACING));
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2680 state = super.method_9605(context);
        if (state == null) {
            return null;
        }
        class_2338 pos = context.method_8037();
        class_1937 level = context.method_8045();
        class_3610 fluid = level.method_8316(pos);
        boolean shouldOverheat = MagniaSproutBlock.shouldOverheat(level, pos);
        return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(this.getNeighborSignal(state, (class_8235)level, pos, (class_2350)state.method_11654((class_2769)FACING)) && !shouldOverheat))).method_11657((class_2769)OVERHEATED, (Comparable)Boolean.valueOf(shouldOverheat))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.method_15772() == class_3612.field_15910));
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 state2, class_1936 world, class_2338 pos, class_2338 pos2) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, state2, world, pos, pos2);
    }

    public class_3610 method_9545(class_2680 state) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return super.method_9545(state);
    }

    private boolean getNeighborSignal(class_2680 state, class_8235 level, class_2338 pos, class_2350 facing) {
        if (MagniaUtil.getStrongestPowerSignal(state, level, pos, facing.method_10153()) > 0) {
            return true;
        }
        for (class_2350 direction : class_2350.values()) {
            if (direction == facing || !level.method_49807(pos.method_10093(direction), direction)) continue;
            return true;
        }
        if (level.method_49807(pos, class_2350.field_11033)) {
            return true;
        }
        class_2338 abovePos = pos.method_10084();
        for (class_2350 direction : class_2350.values()) {
            if (direction == class_2350.field_11033 || !level.method_49807(abovePos.method_10093(direction), direction)) continue;
            return true;
        }
        return false;
    }

    private void updateState(class_2680 state, class_1937 level, class_2338 pos, boolean schedule) {
        if (level.method_8608()) {
            return;
        }
        boolean hasSignal = this.getNeighborSignal(state, (class_8235)level, pos, (class_2350)state.method_11654((class_2769)FACING));
        boolean shouldOverheat = MagniaSproutBlock.shouldOverheat(level, pos);
        boolean overheated = MagniaSproutBlock.isOverheated(state);
        boolean powered = MagniaSproutBlock.isPowered(state);
        if (overheated != shouldOverheat) {
            this.setOverheated(state, level, pos, shouldOverheat);
        }
        if (powered != hasSignal) {
            if (hasSignal) {
                this.trySetPowered(state, level, pos);
            } else if (schedule) {
                level.method_39279(pos, (class_2248)this, 5);
            } else {
                this.setPowered(state, level, pos, false);
            }
        }
    }

    protected void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 pos2, boolean bl) {
        this.updateState(state, level, pos, true);
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        this.updateState(state, (class_1937)level, pos, false);
    }

    protected void method_9606(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        if (!MagniaSproutBlock.isPowered(state) && player.method_5998(class_1268.field_5808).method_31573(EnderscapeItemTags.POWERS_MAGNIA_WHEN_MINED_WITH) && this.trySetPowered(state, level, pos)) {
            level.method_39279(pos, (class_2248)this, 30);
        }
        super.method_9606(state, level, pos, player);
    }

    public void method_19286(class_1937 level, class_2680 state, class_3965 hit, class_1676 projectile) {
        class_2338 pos = hit.method_17777();
        if (!MagniaSproutBlock.isPowered(state) && !MagniaSproutBlock.isOverheated(state) && this.trySetPowered(state, level, pos)) {
            level.method_39279(pos, (class_2248)this, 20);
        }
    }

    protected void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        class_2338 relative = pos.method_10093(MagniaSproutBlock.getFacing(state));
        if (MagniaSproutBlock.shouldBlisterMagnia(state, (class_1937)level, relative) && random.method_43048(3) == 0) {
            level.method_8501(relative, (class_2680)EnderscapeBlocks.BLISTERED_MAGNIA.method_9564().method_11657(StateProperties.OPTIONAL_MAGNIA_POLARITY, (Comparable)((Object)BlisteredMagniaBlock.selectPolarity((class_4538)level, relative))));
            class_243 center = relative.method_46558();
            level.method_14199((class_2394)EnderscapeParticles.MAGNIA_BLISTERING, center.method_10216(), center.method_10214(), center.method_10215(), 12, (double)0.7f, (double)0.7f, (double)0.7f, 0.0);
        }
    }

    private static boolean shouldBlisterMagnia(class_2680 state, class_1937 level, class_2338 relative) {
        return MagniaSproutBlock.isPowered(state) && !level.method_8320(relative).method_26215() && level.method_8320(relative).method_26204() instanceof MagniaBlock && MagniaUtil.isMatchingPolarity(state, level.method_8320(relative));
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        class_2338 side;
        class_2680 state2;
        class_2350 direction;
        class_2338 relative = pos.method_10093(MagniaSproutBlock.getFacing(state));
        if (!(!MagniaSproutBlock.shouldBlisterMagnia(state, level, relative) || random.method_43048(2) != 0 || (direction = class_2350.method_10162((class_5819)random)).method_10166() == class_2350.class_2351.field_11052 || (state2 = level.method_8320(side = relative.method_10093(direction))).method_26225() && state2.method_26206((class_1922)level, side, direction.method_10153()))) {
            double d = direction.method_10148() == 0 ? random.method_43058() : 0.5 + (double)direction.method_10148() * 0.6;
            double e = direction.method_10164() == 0 ? random.method_43058() : 0.5 + (double)direction.method_10164() * 0.6;
            double f = direction.method_10165() == 0 ? random.method_43058() : 0.5 + (double)direction.method_10165() * 0.6;
            level.method_8406((class_2394)EnderscapeParticles.MAGNIA_BLISTERING, (double)relative.method_10263() + d, (double)relative.method_10264() + e, (double)relative.method_10260() + f, 0.0, 0.0, 0.0);
        }
        if (MagniaSproutBlock.canPullEntities(state)) {
            this.getPolarity(state).ifPresent(polarity -> {
                class_243 start = class_243.method_24953((class_2382)pos);
                class_243 end = class_243.method_24953((class_2382)MagniaSproutBlockEntity.getEndOfRange(level, state, pos, MagniaSproutBlock.getFacing(state)));
                class_243 position = polarity.getSproutParticlePosition().apply(start, end).method_1031((double)polarity.getSproutParticleOffset().method_33920(random), (double)polarity.getSproutParticleOffset().method_33920(random), (double)polarity.getSproutParticleOffset().method_33920(random));
                class_243 speed = polarity.getSproutParticleSpeed().apply(start, end);
                level.method_8406((class_2394)polarity.getSproutParticleOptions(), position.field_1352, position.field_1351, position.field_1350, speed.field_1352, speed.field_1351, speed.field_1350);
            });
        }
    }

    @Override
    public Optional<MagniaPolarity> getPolarity(class_2680 state) {
        return Optional.ofNullable(this.polarity);
    }
}

