/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.biome.util.BiomeParameters;
import net.bunten.enderscape.client.world.EnderscapeSkybox;
import net.bunten.enderscape.util.RGBA;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4543;
import net.minecraft.class_638;
import net.minecraft.class_758;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_758.class}, priority=2000)
public class FogRendererMixin {
    @Inject(method={"setupColor"}, at={@At(value="RETURN")})
    private static void setupColor(class_4184 camera, float f, class_638 level, int i, float g, CallbackInfo ci) {
        class_4543 manager = level.method_22385();
        class_243 pos = camera.method_19326().method_1023(2.0, 2.0, 2.0).method_1021(0.25);
        float gamma = EnderscapeSkybox.gammaFactor();
        EnderscapeSkybox.fogStartDensity = RGBA.sampleFloat(manager, pos, BiomeParameters::fogStartDensity, 1.0f);
        EnderscapeSkybox.fogEndDensity = RGBA.sampleFloat(manager, pos, BiomeParameters::fogEndDensity, 1.0f);
        EnderscapeSkybox.nebulaColor = RGBA.sampleVector4f(manager, pos, BiomeParameters::nebulaRGBA, BiomeParameters.DEFAULT_NEBULA_COLOR).mul(gamma, gamma, gamma, 1.0f);
        EnderscapeSkybox.starColor = RGBA.sampleVector4f(manager, pos, BiomeParameters::starRGBA, BiomeParameters.DEFAULT_STAR_COLOR).mul(gamma, gamma, gamma, 1.0f);
        EnderscapeSkybox.flashColor = RGBA.sampleVector4f(manager, pos, BiomeParameters::flashRGBA, BiomeParameters.DEFAULT_FLASH_COLOR);
    }

    @Inject(at={@At(value="RETURN")}, method={"setupFog(Lnet/minecraft/client/Camera;Lnet/minecraft/client/renderer/FogRenderer$FogMode;FZF)V"})
    private static void afterSetupFog(class_4184 camera, class_758.class_4596 mode, float viewDistance, boolean thickFog, float partialTick, CallbackInfo info) {
        class_638 level = class_310.method_1551().field_1687;
        if (EnderscapeConfig.getInstance().skyboxAddDynamicFogDensity && level != null && level.method_27983() == class_1937.field_25181 && mode == class_758.class_4596.field_20946 && !thickFog) {
            float fogStart = viewDistance * 30.0f * 0.01f / EnderscapeSkybox.fogStartDensity;
            float fogEnd = viewDistance * 95.0f * 0.01f / EnderscapeSkybox.fogEndDensity;
            RenderSystem.setShaderFogStart((float)fogStart);
            RenderSystem.setShaderFogEnd((float)fogEnd);
        }
    }
}

