/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.rubblemite;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Comparator;
import net.bunten.enderscape.entity.rubblemite.Rubblemite;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.tag.EnderscapeBiomeTags;
import net.minecraft.class_1935;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3542;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public enum RubblemiteVariant implements class_3542
{
    END_STONE(0, "end_stone", (class_1935)class_2246.field_10471, 8, EnderscapeBiomeTags.DOES_NOT_SPAWN_END_STONE_RUBBLEMITES),
    MIRESTONE(1, "mirestone", (class_1935)EnderscapeBlocks.MIRESTONE, 4, EnderscapeBiomeTags.DOES_NOT_SPAWN_MIRESTONE_RUBBLEMITES),
    VERADITE(2, "veradite", (class_1935)EnderscapeBlocks.VERADITE, 1, EnderscapeBiomeTags.DOES_NOT_SPAWN_VERADITE_RUBBLEMITES),
    KURODITE(3, "kurodite", (class_1935)EnderscapeBlocks.KURODITE, 1, EnderscapeBiomeTags.DOES_NOT_SPAWN_KURODITE_RUBBLEMITES);

    public static final class_2940<Integer> DATA;
    public static final String KEY = "RubblemiteVariant";
    public static final Codec<RubblemiteVariant> CODEC;
    public static final RubblemiteVariant[] BY_ID;
    private final int id;
    private final String name;
    private final class_1935 dropItem;
    private final int weight;
    private final class_6862<class_1959> skippedBiomes;

    private RubblemiteVariant(int id, String name, class_1935 dropItem, int weight, class_6862<class_1959> skippedBiomes) {
        this.id = id;
        this.name = name;
        this.dropItem = dropItem;
        this.weight = weight;
        this.skippedBiomes = skippedBiomes;
    }

    public int getId() {
        return this.id;
    }

    public static RubblemiteVariant byId(int id) {
        return id >= 0 && id < BY_ID.length ? BY_ID[id] : END_STONE;
    }

    public String getName() {
        return this.name;
    }

    public String method_15434() {
        return this.getName();
    }

    public class_1935 getDropItem() {
        return this.dropItem;
    }

    public int getWeight() {
        return this.weight;
    }

    public class_6862<class_1959> getSkippedBiomes() {
        return this.skippedBiomes;
    }

    public static RubblemiteVariant get(Rubblemite mob) {
        return BY_ID[(Integer)mob.method_5841().method_12789(DATA)];
    }

    public static void set(Rubblemite mob, RubblemiteVariant variant) {
        mob.method_5841().method_12778(DATA, (Object)variant.getId());
    }

    public static RubblemiteVariant pickForSpawning(class_5819 random, class_6880<class_1959> biome) {
        int totalWeight = Arrays.stream(RubblemiteVariant.values()).filter(variant -> !biome.method_40220(variant.getSkippedBiomes())).mapToInt(RubblemiteVariant::getWeight).sum();
        int roll = random.method_43048(totalWeight);
        int cumulativeWeight = 0;
        for (RubblemiteVariant variant2 : RubblemiteVariant.values()) {
            if (biome.method_40220(variant2.getSkippedBiomes()) || roll >= (cumulativeWeight += variant2.getWeight())) continue;
            return variant2;
        }
        throw new IllegalStateException("No variant could be selected");
    }

    static {
        DATA = class_2945.method_12791(Rubblemite.class, (class_2941)class_2943.field_13327);
        CODEC = class_3542.method_28140(RubblemiteVariant::values);
        BY_ID = (RubblemiteVariant[])Arrays.stream(RubblemiteVariant.values()).sorted(Comparator.comparingInt(RubblemiteVariant::getId)).toArray(RubblemiteVariant[]::new);
    }
}

