/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.feature.generator;

import net.bunten.enderscape.block.AbstractVineBlock;
import net.bunten.enderscape.block.state.StateProperties;
import net.bunten.enderscape.feature.LargeCelestialChanterelleConfig;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4657;
import net.minecraft.class_5819;
import net.minecraft.class_6005;

public class LargeCelestialChanterelleGenerator {
    public static final class_4657 FLANGER_BERRIES = new class_4657(class_6005.method_34971().method_34975((Object)EnderscapeBlocks.FLANGER_BERRY_FLOWER.method_9564(), 1).method_34975((Object)EnderscapeBlocks.UNRIPE_FLANGER_BERRY_BLOCK.method_9564(), 1).method_34975((Object)EnderscapeBlocks.RIPE_FLANGER_BERRY_BLOCK.method_9564(), 1));

    public static boolean tryGenerate(class_1936 level, class_2338 origin, class_5819 random, LargeCelestialChanterelleConfig config) {
        class_2350 direction = class_2350.field_11036;
        class_2338 attached = origin.method_10093(direction.method_10153());
        if (level.method_8320(attached).method_26206((class_1922)level, attached, direction)) {
            for (int i = 0; i < config.tries(); ++i) {
                int radius;
                int height = config.height().method_35008(random);
                if (!LargeCelestialChanterelleGenerator.isEnoughAir(level, origin, height, (radius = (int)((float)height / config.cap_radius_division())) / 2)) continue;
                LargeCelestialChanterelleGenerator.generate(level, origin, random, config, height, radius);
                return true;
            }
        }
        return false;
    }

    public static void generate(class_1936 level, class_2338 pos, class_5819 random, LargeCelestialChanterelleConfig config, int height, int radius) {
        level.method_8652(pos, class_2246.field_10124.method_9564(), 4);
        BlockUtil.place(level, pos.method_10074(), class_2246.field_10471.method_9564());
        LargeCelestialChanterelleGenerator.generateCap(level, random, pos.method_10086(height), config, radius);
        for (int i = 0; i < height; ++i) {
            BlockUtil.place(level, pos.method_10086(i), EnderscapeBlocks.CELESTIAL_STEM.method_9564());
        }
    }

    public static boolean isEnoughAir(class_1936 level, class_2338 pos, int height, int radius) {
        for (int i = 1; i < height + 1; ++i) {
            if (level.method_22347(pos.method_10086(i))) continue;
            return false;
        }
        return true;
    }

    protected static void generateVines(class_1936 level, class_5819 random, class_2338 origin, LargeCelestialChanterelleConfig config, int radius) {
        int generatedVines = 0;
        int maxTries = config.vine_generation_tries();
        int maxRadius = (int)((float)radius * 0.8f);
        int minHeight = (int)((float)radius * 0.4f);
        for (int i = 0; i < maxTries; ++i) {
            class_2338 pos = BlockUtil.random(origin, random, maxRadius, 0, maxRadius).method_10087(class_3532.method_15395((class_5819)random, (int)0, (int)minHeight));
            for (int offset = -4; offset < 4; ++offset) {
                class_2338 testPos = pos.method_10086(offset);
                if (!level.method_8320(testPos).method_26215() || !level.method_8320(testPos.method_10084()).method_26164(EnderscapeBlockTags.FLANGER_BERRY_VINE_PLANTABLE_ON)) continue;
                pos = testPos;
                break;
            }
            if (pos.method_19771((class_2382)origin, (double)((int)((float)radius * 0.6f))) || generatedVines > radius / 4 && random.method_43057() <= config.excess_vine_discard_chance() || !LargeCelestialChanterelleGenerator.canVineGrow(level, pos)) continue;
            LargeCelestialChanterelleGenerator.generateVine(level, random, pos, radius);
            ++generatedVines;
        }
    }

    private static boolean canVineGrow(class_1936 level, class_2338 pos) {
        return level.method_22347(pos) && level.method_22347(pos.method_10074()) && level.method_8320(pos.method_10084()).method_26164(EnderscapeBlockTags.FLANGER_BERRY_VINE_PLANTABLE_ON);
    }

    private static void generateVine(class_1936 level, class_5819 random, class_2338 start, int radius) {
        int length = class_3532.method_15395((class_5819)random, (int)((int)((float)radius * 0.8f)), (int)(radius * 2));
        class_2338.class_2339 mutable = start.method_25503();
        for (int i = 0; i <= length; ++i) {
            if (!level.method_22347((class_2338)mutable)) continue;
            if (i == length || !level.method_22347(mutable.method_10074())) {
                BlockUtil.replace(level, (class_2338)mutable, FLANGER_BERRIES.method_23455(random, (class_2338)mutable));
                break;
            }
            BlockUtil.replace(level, (class_2338)mutable, (class_2680)((class_2680)EnderscapeBlocks.FLANGER_BERRY_VINE.method_9564().method_11657((class_2769)StateProperties.field_12493, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)AbstractVineBlock.AGE, (Comparable)Integer.valueOf(15)));
            mutable.method_10098(class_2350.field_11033);
        }
    }

    protected static void generateCap(class_1936 level, class_5819 random, class_2338 pos, LargeCelestialChanterelleConfig config, int radius) {
        for (int x = -radius + 1; x < radius; ++x) {
            for (int z = -radius + 1; z < radius; ++z) {
                double distance = Math.sqrt(x * x + z * z);
                if (!(distance <= (double)radius)) continue;
                for (int capOrder = 1; capOrder < radius; ++capOrder) {
                    int droopAmount = distance >= (double)((float)radius * config.cap_droop_percentage()) && capOrder == 1 && radius > 3 ? 1 : 0;
                    BlockUtil.replace(level, pos.method_10069(x / capOrder, -(2 * capOrder + droopAmount) + 2, z / capOrder), EnderscapeBlocks.CELESTIAL_CAP.method_9564());
                }
            }
        }
        LargeCelestialChanterelleGenerator.generateVines(level, random, pos.method_10074(), config, radius);
    }
}

