/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.registry.EnderscapeBiomeSounds;
import net.bunten.enderscape.registry.EnderscapeBiomes;
import net.bunten.enderscape.registry.EnderscapeEntities;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.bunten.enderscape.registry.EnderscapePlacedFeatures;
import net.bunten.enderscape.registry.tag.EnderscapeBiomeTags;
import net.bunten.enderscape.registry.tag.EnderscapeSoundEventTags;
import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.minecraft.class_1143;
import net.minecraft.class_1311;
import net.minecraft.class_1972;
import net.minecraft.class_2394;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_4761;
import net.minecraft.class_4967;
import net.minecraft.class_4968;
import net.minecraft.class_5195;
import net.minecraft.class_5483;
import net.minecraft.class_6813;
import net.minecraft.class_6880;
import net.minecraft.class_6908;

public class EnderscapeBiomeModifications {
    private static final EnderscapeConfig CONFIG = EnderscapeConfig.getInstance();
    private static final Predicate<BiomeSelectionContext> IS_END = selection -> selection.getBiomeRegistryEntry().method_40220(class_6908.field_37394);

    private static void registerAmbienceModifications() {
        EnderscapeBiomeModifications.conditionalAmbienceModification(EnderscapeBiomeModifications.CONFIG.ambienceUpdateMusicPools, "update_end_biome_music_when_default", selection -> selection.getBiome().method_27343().isPresent() && ((class_5195)selection.getBiome().method_27343().get()).equals(class_1143.field_5583), (selection, modification) -> modification.getEffects().setMusic(new class_5195(EnderscapeBiomeSounds.DEFAULT_END.music(), 12000, 24000, false)));
        EnderscapeBiomeModifications.conditionalAmbienceModification(EnderscapeBiomeModifications.CONFIG.ambienceUpdateGrassColors, "update_end_biome_grass_color_when_default", selection -> selection.getBiome().method_24377().method_30812().isEmpty(), (selection, modification) -> modification.getEffects().setGrassColor(10598275));
        EnderscapeBiomeModifications.conditionalAmbienceModification(EnderscapeBiomeModifications.CONFIG.ambienceUpdateFoliageColors, "update_end_biome_foliage_color_when_default", selection -> selection.getBiome().method_24377().method_30811().isEmpty(), (selection, modification) -> modification.getEffects().setFoliageColor(10598275));
        EnderscapeBiomeModifications.conditionalAmbienceModification(EnderscapeBiomeModifications.CONFIG.ambienceUpdateWaterColors, "update_end_biome_water_color_when_default", selection -> selection.getBiome().method_8687() == 4159204, (selection, modification) -> modification.getEffects().setWaterColor(7961249));
        EnderscapeBiomeModifications.conditionalAmbienceModification(EnderscapeBiomeModifications.CONFIG.ambienceUpdateWaterFogColors, "update_end_biome_water_fog_color_when_default", selection -> selection.getBiome().method_8713() == 329011, (selection, modification) -> modification.getEffects().setWaterFogColor(3684693));
        EnderscapeBiomeModifications.conditionalAmbienceModification(EnderscapeBiomeModifications.CONFIG.ambienceUpdateParticles, "update_end_biome_particles_when_missing", selection -> selection.getBiome().method_24378().isEmpty(), (selection, modification) -> modification.getEffects().setParticleConfig(new class_4761((class_2394)EnderscapeParticles.VOID_STARS, 0.003f)));
        EnderscapeBiomeModifications.conditionalAmbienceModification(EnderscapeBiomeModifications.CONFIG.ambienceUpdateSkyColors, "update_end_biome_sky_colors_when_default", selection -> selection.getBiome().method_8697() == 0, (selection, modification) -> modification.getEffects().setSkyColor(1577761));
        EnderscapeBiomeModifications.conditionalAmbienceModification(EnderscapeBiomeModifications.CONFIG.ambienceUpdateFogColors, "update_end_biome_fog_colors_when_default", selection -> selection.getBiome().method_8697() == 0xA080A0, (selection, modification) -> modification.getEffects().setFogColor(EnderscapeBiomes.DEFAULT_FOG_COLOR));
        EnderscapeBiomeModifications.conditionalAmbienceModification(EnderscapeBiomeModifications.CONFIG.ambienceUpdateLoopSounds, "update_end_biome_ambient_loop_when_missing_or_replaceable", selection -> {
            Optional loop = selection.getBiome().method_24935();
            return loop.isEmpty() || ((class_6880)loop.get()).method_40220(EnderscapeSoundEventTags.AMBIENCE_REPLACEABLE_BY_ENDERSCAPE);
        }, (selection, modification) -> modification.getEffects().setAmbientSound(EnderscapeBiomeSounds.DEFAULT_END.loop()));
        EnderscapeBiomeModifications.conditionalAmbienceModification(EnderscapeBiomeModifications.CONFIG.ambienceUpdateAdditionSounds, "update_end_biome_ambient_additions_when_missing_or_replaceable", selection -> {
            Optional additions = selection.getBiome().method_24937();
            return additions.isEmpty() || ((class_4967)additions.get()).method_26098().method_40220(EnderscapeSoundEventTags.AMBIENCE_REPLACEABLE_BY_ENDERSCAPE);
        }, (selection, modification) -> modification.getEffects().setAdditionsSound(new class_4967(EnderscapeBiomeSounds.DEFAULT_END.additions(), 7.5E-4)));
        EnderscapeBiomeModifications.conditionalAmbienceModification(EnderscapeBiomeModifications.CONFIG.ambienceUpdateMoodSounds, "update_end_biome_ambience_mood_when_missing_or_replaceable", selection -> {
            Optional additions = selection.getBiome().method_24936();
            return additions.isEmpty() || ((class_4968)additions.get()).method_26100().method_40220(EnderscapeSoundEventTags.AMBIENCE_REPLACEABLE_BY_ENDERSCAPE);
        }, (selection, modification) -> modification.getEffects().setMoodSound(new class_4968(EnderscapeBiomeSounds.DEFAULT_END.mood(), 6000, 8, 2.0)));
    }

    private static void registerFeatureModifications() {
        BiomeModifications.create((class_2960)Enderscape.id("add_global_features")).add(ModificationPhase.ADDITIONS, IS_END.and(selection -> !selection.getBiomeRegistryEntry().method_40220(EnderscapeBiomeTags.EXCLUDED_FROM_GLOBAL_FEATURE_ADDITIONS)), (selection, modification) -> {
            BiomeModificationContext.GenerationSettingsContext generation = modification.getGenerationSettings();
            generation.addFeature(class_2893.class_2895.field_13176, EnderscapePlacedFeatures.VOID_SHALE);
            generation.addFeature(class_2893.class_2895.field_13176, EnderscapePlacedFeatures.VOID_SHALE_BLOBS);
            generation.addFeature(class_2893.class_2895.field_13176, EnderscapePlacedFeatures.VERADITE);
            generation.addFeature(class_2893.class_2895.field_13176, EnderscapePlacedFeatures.MIRESTONE_BLOBS);
            generation.addFeature(class_2893.class_2895.field_13176, EnderscapePlacedFeatures.SHADOLINE_ORE);
            generation.addFeature(class_2893.class_2895.field_13176, EnderscapePlacedFeatures.SCATTERED_SHADOLINE_ORE);
            generation.addFeature(class_2893.class_2895.field_13176, EnderscapePlacedFeatures.NEBULITE_ORE);
            generation.addFeature(class_2893.class_2895.field_13176, EnderscapePlacedFeatures.CEILING_NEBULITE_ORE);
        });
        BiomeModifications.create((class_2960)Enderscape.id("add_new_barrens_content")).add(ModificationPhase.ADDITIONS, IS_END.and(selection -> selection.getBiomeRegistryEntry().method_40220(EnderscapeBiomeTags.HAS_BARRENS_ADDITIONS)), (selection, modification) -> {
            modification.getSpawnSettings().addSpawn(class_1311.field_6302, new class_5483.class_1964(EnderscapeEntities.RUBBLEMITE, 2, 2, 3));
            BiomeModificationContext.GenerationSettingsContext generation = modification.getGenerationSettings();
            generation.addFeature(class_2893.class_2895.field_13178, EnderscapePlacedFeatures.CHORUS_SPROUTS);
            generation.addFeature(class_2893.class_2895.field_13178, EnderscapePlacedFeatures.DRY_END_GROWTH);
            generation.addFeature(class_2893.class_2895.field_13178, EnderscapePlacedFeatures.MURUBLIGHT_BRACKET);
        });
        EnderscapeBiomeModifications.replaceChorusPlants();
        EnderscapeBiomeModifications.replaceSmallEndIslands();
        BiomeModifications.create((class_2960)Enderscape.id("remove_minecraft_end_gateways")).add(ModificationPhase.REMOVALS, IS_END.and(selection -> selection.hasPlacedFeature(class_6813.field_35998)), (selection, modification) -> modification.getGenerationSettings().removeFeature(class_6813.field_35998));
    }

    private static void replaceChorusPlants() {
        BiomeModifications.create((class_2960)Enderscape.id("add_enderscape_chorus_plants")).add(ModificationPhase.ADDITIONS, IS_END.and(selection -> selection.hasPlacedFeature(class_6813.field_35999) || selection.getBiomeKey() == class_1972.field_9447), (selection, modification) -> modification.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, EnderscapePlacedFeatures.CHORUS_PLANTS));
        BiomeModifications.create((class_2960)Enderscape.id("remove_minecraft_chorus_plants")).add(ModificationPhase.REMOVALS, IS_END.and(selection -> selection.hasPlacedFeature(class_6813.field_35999)), (selection, modification) -> modification.getGenerationSettings().removeFeature(class_6813.field_35999));
    }

    private static void replaceSmallEndIslands() {
        BiomeModifications.create((class_2960)Enderscape.id("add_enderscape_islands")).add(ModificationPhase.ADDITIONS, IS_END.and(selection -> selection.hasPlacedFeature(class_6813.field_36000)), (selection, modification) -> modification.getGenerationSettings().addFeature(class_2893.class_2895.field_13174, EnderscapePlacedFeatures.SMALL_ISLANDS));
        BiomeModifications.create((class_2960)Enderscape.id("remove_small_end_islands")).add(ModificationPhase.REMOVALS, IS_END.and(selection -> selection.hasPlacedFeature(class_6813.field_36000)), (selection, modification) -> modification.getGenerationSettings().removeFeature(class_6813.field_36000));
    }

    private static void conditionalAmbienceModification(boolean condition, String name, Predicate<BiomeSelectionContext> predicate, BiConsumer<BiomeSelectionContext, BiomeModificationContext> consumer) {
        if (!condition) {
            return;
        }
        BiomeModifications.create((class_2960)Enderscape.id(name)).add(ModificationPhase.REPLACEMENTS, IS_END.and(predicate.or(selection -> selection.getBiomeRegistryEntry().method_40220(EnderscapeBiomeTags.OVERRIDES_DEFAULT_AMBIENCE))), consumer);
    }

    static {
        EnderscapeBiomeModifications.registerAmbienceModifications();
        EnderscapeBiomeModifications.registerFeatureModifications();
    }
}

