/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.ToIntFunction;
import net.bunten.enderscape.block.HasMagniaPolarity;
import net.bunten.enderscape.block.HasMagniaPowerSignal;
import net.bunten.enderscape.block.properties.MagniaPolarity;
import net.bunten.enderscape.block.state.MagniaPolarityProperty;
import net.bunten.enderscape.block.state.StateProperties;
import net.bunten.enderscape.registry.EnderscapeBlockSounds;
import net.bunten.enderscape.util.MagniaUtil;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_9904;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PolarizedMagniaBlock
extends class_2248
implements HasMagniaPolarity,
HasMagniaPowerSignal {
    public static final MapCodec<PolarizedMagniaBlock> CODEC = PolarizedMagniaBlock.method_54094(PolarizedMagniaBlock::new);
    public static final class_2746 POWERED = StateProperties.field_12484;
    public static final class_2754<MagniaPolarityProperty> POLARITY = StateProperties.MAGNIA_POLARITY;

    protected MapCodec<? extends PolarizedMagniaBlock> method_53969() {
        return CODEC;
    }

    public PolarizedMagniaBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657(POLARITY, (Comparable)((Object)MagniaPolarityProperty.ALLURING))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public static MagniaPolarityProperty getPolarityProperty(class_2680 state) {
        return (MagniaPolarityProperty)((Object)state.method_11654(POLARITY));
    }

    @NotNull
    public static ToIntFunction<class_2680> getLightLevel() {
        return state -> 14;
    }

    public static class_3620 getMapColor(class_2680 state) {
        return PolarizedMagniaBlock.getPolarityProperty(state).getMapColor();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{POLARITY, POWERED});
    }

    @Override
    public Optional<MagniaPolarity> getPolarity(class_2680 state) {
        return Optional.ofNullable(PolarizedMagniaBlock.getPolarityProperty(state).get());
    }

    @Override
    public int getMagniaPowerSignal(class_2680 state, class_2680 neighbor) {
        return MagniaUtil.isMatchingPolarity(state, neighbor) ? 15 : 0;
    }

    protected void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 state2, boolean bl) {
        if (state2.method_26204() != state.method_26204() && level instanceof class_3218) {
            class_3218 server = (class_3218)level;
            this.checkAndFlip(state, server, pos);
        }
    }

    protected void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, @Nullable class_9904 orientation, boolean bl) {
        if (level instanceof class_3218) {
            class_3218 server = (class_3218)level;
            this.checkAndFlip(state, server, pos);
        }
    }

    public void checkAndFlip(class_2680 state, class_3218 level, class_2338 pos) {
        boolean powered = level.method_49803(pos);
        if (powered != (Boolean)state.method_11654((class_2769)POWERED)) {
            class_2680 state2 = state;
            if (!((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
                state2 = (class_2680)state.method_28493(POLARITY);
                level.method_45447(null, pos, EnderscapeBlockSounds.POLARIZED_MAGNIA_SWAP_POLARITY, class_3419.field_15245);
            }
            level.method_8652(pos, (class_2680)state2.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }
}

