/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.registry;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.registry.EnderscapeSoundTypes;
import net.bunten.enderscape.sound.SoundTypeOverride;
import net.minecraft.class_2480;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_7923;

public class EnderscapeSoundTypeOverrides {
    private static final EnderscapeConfig CONFIG = EnderscapeConfig.getInstance();
    public static final List<SoundTypeOverride> SOUND_TYPE_OVERRIDES = new ArrayList<SoundTypeOverride>();
    private static final List<class_2680> IGNORED_STATES = new ArrayList<class_2680>();
    private static final Map<class_2680, class_2498> SOUND_TYPE_CACHE = new IdentityHashMap<class_2680, class_2498>();

    public static Optional<class_2498> getSoundType(class_2680 state) {
        if (IGNORED_STATES.contains(state)) {
            return Optional.empty();
        }
        return Optional.ofNullable(SOUND_TYPE_CACHE.computeIfAbsent(state, s -> {
            for (SoundTypeOverride override : SOUND_TYPE_OVERRIDES) {
                if (!override.applies((class_2680)s)) continue;
                return override.getSoundType();
            }
            IGNORED_STATES.add((class_2680)s);
            return null;
        }));
    }

    public static void register(SoundTypeOverride override) {
        Objects.requireNonNull(override);
        SOUND_TYPE_OVERRIDES.add(override);
    }

    public static void register(SoundTypeOverride ... overrides) {
        for (SoundTypeOverride override : overrides) {
            EnderscapeSoundTypeOverrides.register(override);
        }
    }

    private static String getNameOf(class_2680 state) {
        return class_7923.field_41175.method_10221((Object)state.method_26204()).method_12832();
    }

    static {
        Map<class_2498, Predicate<class_2680>> overrides = Map.of(EnderscapeSoundTypes.CHORUS_PLANT, state -> EnderscapeSoundTypeOverrides.CONFIG.blocksSoundUpdateChorus && EnderscapeSoundTypeOverrides.getNameOf(state).equals("chorus_plant"), EnderscapeSoundTypes.CHORUS_FLOWER, state -> EnderscapeSoundTypeOverrides.CONFIG.blocksSoundUpdateChorus && EnderscapeSoundTypeOverrides.getNameOf(state).equals("chorus_flower"), EnderscapeSoundTypes.PURPUR, state -> EnderscapeSoundTypeOverrides.CONFIG.blocksSoundUpdatePurpur && EnderscapeSoundTypeOverrides.getNameOf(state).contains("purpur") && !EnderscapeSoundTypeOverrides.getNameOf(state).contains("dusk"), EnderscapeSoundTypes.END_PORTAL_FRAME, state -> EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateEndPortalFrame && EnderscapeSoundTypeOverrides.getNameOf(state).equals("end_portal_frame"), EnderscapeSoundTypes.END_PORTAL, state -> EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateEndPortals && EnderscapeSoundTypeOverrides.getNameOf(state).equals("end_portal"), EnderscapeSoundTypes.END_GATEWAY, state -> EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateEndPortals && EnderscapeSoundTypeOverrides.getNameOf(state).equals("end_gateway"), EnderscapeSoundTypes.END_ROD, state -> EnderscapeSoundTypeOverrides.CONFIG.blockSoundsUpdateEndRods && EnderscapeSoundTypeOverrides.getNameOf(state).equals("end_rod"), EnderscapeSoundTypes.END_STONE, state -> EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateEndStone && EnderscapeSoundTypeOverrides.getNameOf(state).contains("end_stone") && !EnderscapeSoundTypeOverrides.getNameOf(state).contains("brick") && !EnderscapeSoundTypeOverrides.getNameOf(state).contains("chiseled") && !EnderscapeSoundTypeOverrides.getNameOf(state).contains("veiled"), EnderscapeSoundTypes.END_STONE_BRICKS, state -> EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateEndStoneBricks && EnderscapeSoundTypeOverrides.getNameOf(state).contains("end_stone") && (EnderscapeSoundTypeOverrides.getNameOf(state).contains("brick") || EnderscapeSoundTypeOverrides.getNameOf(state).contains("chiseled")), EnderscapeSoundTypes.SHULKER_BOX, state -> EnderscapeSoundTypeOverrides.CONFIG.blockSoundUpdateShulkerBoxes && state.method_26204() instanceof class_2480);
        overrides.forEach((sound, condition) -> EnderscapeSoundTypeOverrides.register(new SoundTypeOverride((class_2498)sound, (Predicate<class_2680>)condition)));
    }
}

