/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import net.bunten.enderscape.block.properties.DirectionSet;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1821;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3558;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractOvergrowthBlock
extends class_2318
implements class_2256 {
    protected final boolean needsAir;
    @Nullable
    protected final class_2248 pathBlock;
    protected final class_2248 baseBlock;
    public final class_3414 flattenSound;
    protected final boolean isPath;
    protected final DirectionSet properties;
    protected int horizontalBonemealRange = 8;

    public AbstractOvergrowthBlock(boolean needsAir, class_2248 baseBlock, @Nullable class_2248 pathBlock, @Nullable class_3414 flattenSound, boolean isPath, DirectionSet properties, class_4970.class_2251 settings) {
        super(settings);
        this.needsAir = needsAir;
        this.baseBlock = baseBlock;
        this.pathBlock = pathBlock;
        this.flattenSound = flattenSound;
        this.isPath = isPath;
        this.properties = properties;
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)field_10927, (Comparable)class_2350.field_11036));
    }

    public AbstractOvergrowthBlock(boolean needsAir, class_2248 baseBlock, @Nullable class_2248 pathBlock, @Nullable class_3414 flattenSound, DirectionSet properties, class_4970.class_2251 settings) {
        this(needsAir, baseBlock, pathBlock, flattenSound, false, properties, settings);
    }

    public AbstractOvergrowthBlock(boolean needsAir, class_2248 baseBlock, DirectionSet properties, class_4970.class_2251 settings) {
        this(needsAir, baseBlock, null, null, true, properties, settings);
    }

    public static class_2350 getDirection(class_2680 state) {
        return (class_2350)state.method_11654((class_2769)field_10927);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_10927});
    }

    public class_2680 method_9605(class_1750 context) {
        class_2350 dir = context.method_7715().method_10153();
        if (!this.properties.supports(dir)) {
            dir = class_2350.field_11036;
        }
        class_2680 state = (class_2680)this.method_9564().method_11657((class_2769)field_10927, (Comparable)dir);
        if (this.isPath && !this.hasAir(state, (class_4538)context.method_8045(), context.method_8037())) {
            return class_2248.method_9582((class_2680)state, (class_2680)this.baseBlock.method_9564(), (class_1936)context.method_8045(), (class_2338)context.method_8037());
        }
        return state;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)field_10927, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)field_10927)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return (class_2680)state.method_11657((class_2769)field_10927, (Comparable)mirror.method_10343((class_2350)state.method_11654((class_2769)field_10927)));
    }

    public class_2256.class_9077 method_55770() {
        return class_2256.class_9077.field_47835;
    }

    public void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        if (this.needsAir && !this.hasAir(state, (class_4538)level, pos)) {
            class_2680 state2 = AbstractOvergrowthBlock.method_9582((class_2680)state, (class_2680)this.baseBlock.method_9564(), (class_1936)level, (class_2338)pos);
            level.method_8501(pos, state2);
            level.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43286(null, (class_2680)state2));
        }
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 mob, class_1268 hand, class_3965 result) {
        if (this.pathBlock != null && stack.method_7909() instanceof class_1821 && world.method_8320(pos.method_10093((class_2350)state.method_11654((class_2769)field_10927))).method_26215()) {
            world.method_8396((class_1297)mob, pos, this.flattenSound, class_3419.field_15245, 1.0f, 1.0f);
            if (!world.method_8608()) {
                world.method_8652(pos, (class_2680)this.pathBlock.method_9564().method_11657((class_2769)field_10927, (Comparable)((class_2350)state.method_11654((class_2769)field_10927))), 3);
                stack.method_7970(1, (class_1309)mob, class_1309.method_56079((class_1268)hand));
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
        return !this.isPath && world.method_8320(pos.method_10093(AbstractOvergrowthBlock.getDirection(state))).method_26167();
    }

    public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return !this.isPath;
    }

    public void method_9652(class_3218 level, class_5819 random, class_2338 pos, class_2680 state) {
        int range = this.horizontalBonemealRange / 2;
        level.method_8652(pos, state, 2);
        class_2350 dir = (class_2350)state.method_11654((class_2769)field_10927);
        for (int x = -range + 1; x < range; ++x) {
            for (int y = -12; y < 12; ++y) {
                for (int z = -range + 1; z < range; ++z) {
                    boolean bl;
                    class_2338 pos2 = pos.method_10069(x, y, z);
                    boolean bl2 = bl = level.method_8320(pos2.method_10093(dir)).method_26167() && level.method_8320(pos2).method_27852(this.baseBlock);
                    if (!bl || !(class_3532.method_15355((float)(x * x + y * y + z * z)) <= (float)range) || !(level.method_8409().method_43057() < 0.6f)) continue;
                    level.method_8652(pos2, state, 2);
                }
            }
        }
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (!this.isPath) {
            return super.method_9530(state, world, pos, context);
        }
        return BlockUtil.createRotatedShape(0.0, 0.0, 0.0, 16.0, 15.0, 16.0, (class_2350)state.method_11654((class_2769)field_10927));
    }

    public boolean hasAir(class_2680 state, class_4538 level, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_10927);
        class_2680 relative = level.method_8320(pos.method_10093(facing));
        if (this.isPath) {
            return !relative.method_51367() || relative.method_26204() instanceof class_2349;
        }
        return class_3558.method_20049((class_2680)state, (class_2680)relative, (class_2350)facing, (int)relative.method_26193()) < 15;
    }

    protected boolean method_9526(class_2680 blockState) {
        return this.isPath;
    }

    protected class_2680 method_9559(class_2680 state, class_4538 level, class_10225 access, class_2338 pos, class_2350 direction, class_2338 pos2, class_2680 state2, class_5819 random) {
        if (direction == state.method_11654((class_2769)field_10927) && !this.hasAir(state, level, pos) && this.isPath && this.needsAir) {
            access.method_64310(pos, (class_2248)this, 1);
        }
        return super.method_9559(state, level, access, pos, direction, pos2, state2, random);
    }

    protected void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        class_2680 state2 = AbstractOvergrowthBlock.method_9582((class_2680)state, (class_2680)this.baseBlock.method_9564(), (class_1936)level, (class_2338)pos);
        level.method_8501(pos, state2);
        level.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43286(null, (class_2680)state2));
    }
}

