/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import net.bunten.enderscape.block.HasMagniaPolarity;
import net.bunten.enderscape.block.MagniaSproutBlock;
import net.bunten.enderscape.block.properties.MagniaPolarity;
import net.bunten.enderscape.entity.magnia.MagniaMoveable;
import net.bunten.enderscape.entity.magnia.MagniaProperties;
import net.bunten.enderscape.registry.EnderscapeBlockEntities;
import net.bunten.enderscape.util.MagniaUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2743;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5431;

public class MagniaSproutBlockEntity
extends class_2586 {
    public static final int MAXIMUM_RANGE = 14;

    public MagniaSproutBlockEntity(class_2338 pos, class_2680 state) {
        super(EnderscapeBlockEntities.MAGNIA_SPROUT, pos, state);
    }

    public static class_238 getRange(class_1937 level, class_2680 state, class_2338 originPos) {
        class_2350 direction = MagniaSproutBlock.getFacing(state);
        if (HasMagniaPolarity.has(state) && HasMagniaPolarity.optional(state).isPresent()) {
            class_2338 current = MagniaSproutBlockEntity.getEndOfRange(level, state, originPos, direction);
            class_243 start = class_243.method_24953((class_2382)originPos.method_10093(direction)).method_1019(direction.method_62676().method_1021(-1.0));
            class_243 end = class_243.method_24953((class_2382)current).method_1019(direction.method_62676().method_1021(-0.5));
            class_238 range = new class_238(start, end);
            return switch (direction.method_10166()) {
                default -> throw new MatchException(null, null);
                case class_2350.class_2351.field_11048 -> range.method_1009(0.0, 0.75, 0.75);
                case class_2350.class_2351.field_11052 -> range.method_1009(0.75, 0.0, 0.75);
                case class_2350.class_2351.field_11051 -> range.method_1009(0.75, 0.75, 0.0);
            };
        }
        return new class_238(originPos);
    }

    public static class_2338 getEndOfRange(class_1937 level, class_2680 state, class_2338 origin, class_2350 direction) {
        if (!HasMagniaPolarity.has(state) || HasMagniaPolarity.optional(state).isEmpty()) {
            return origin;
        }
        class_2338.class_2339 mutable = origin.method_25503();
        for (int i = 1; i <= 14; ++i) {
            mutable.method_10098(direction);
            class_2680 other = level.method_8320((class_2338)mutable);
            if (HasMagniaPolarity.has(other) && !MagniaUtil.isMatchingPolarity(state, other) && other.method_30368((class_1922)level, (class_2338)mutable, direction.method_10153(), class_5431.field_25823)) break;
        }
        return mutable;
    }

    private static void move(class_1297 entity, class_243 velocity) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            player.field_13987.method_14364((class_2596)new class_2743(entity));
        }
        if (MagniaMoveable.getMagniaProperties(entity).shouldAddVelocity().test(entity)) {
            entity.method_45319(velocity);
        } else {
            entity.method_18799(velocity);
        }
        entity.field_6007 = true;
    }

    static void doMagniaMovement(class_1297 entity, MagniaSproutBlockEntity blockEntity) {
        MagniaProperties properties = MagniaMoveable.getMagniaProperties(entity);
        if (properties == null) {
            return;
        }
        properties.onMoved().apply(entity);
        class_243 pos = entity.method_5829().method_1005();
        class_2680 state = blockEntity.method_11010();
        class_2350 facing = (class_2350)state.method_11654((class_2769)MagniaSproutBlock.FACING);
        if (HasMagniaPolarity.optional(state).isPresent()) {
            MagniaPolarity type = HasMagniaPolarity.optional(state).get();
            if (type == MagniaPolarity.REPULSIVE) {
                float factor = properties.repelStrength().apply(entity).floatValue();
                class_243 velocity = new class_243((double)facing.method_10148(), (double)facing.method_10164(), (double)facing.method_10165()).method_1029().method_18805((double)factor, (double)factor, (double)factor);
                MagniaSproutBlockEntity.move(entity, velocity);
                if (!MagniaMoveable.wasMovedByMagnia(entity)) {
                    entity.method_5783(type.getMoveSound(), 1.0f, 1.0f);
                }
                MagniaMoveable.setMovedByMagnia(entity, true);
            } else {
                double distance;
                class_243 moveTarget = class_243.method_24953((class_2382)blockEntity.method_11016()).method_1031((double)((float)facing.method_10148() * 1.2f), (double)((float)facing.method_10164() * 1.2f), (double)((float)facing.method_10165() * 1.2f));
                if (MagniaSproutBlockEntity.shouldOffset(blockEntity, facing)) {
                    moveTarget = moveTarget.method_1023(0.0, entity.method_5829().method_17940() * (double)1.2f, 0.0);
                }
                if ((distance = pos.method_1022(moveTarget)) > (double)0.1f) {
                    class_243 velocity = moveTarget.method_1020(pos).method_1029().method_1021((double)(properties.attractStrength().apply(entity).floatValue() * (float)Math.min(distance / 5.0, 1.0)));
                    if (distance < 1.5) {
                        velocity = velocity.method_1021((double)((float)(0.75 + distance / 2.0 * 0.25)));
                    }
                    MagniaSproutBlockEntity.move(entity, velocity);
                    if (!MagniaMoveable.wasMovedByMagnia(entity)) {
                        entity.method_5783(type.getMoveSound(), 1.0f, 1.0f);
                    }
                    MagniaMoveable.setMovedByMagnia(entity, true);
                } else {
                    MagniaSproutBlockEntity.move(entity, class_243.field_1353);
                    MagniaMoveable.setMovedByMagnia(entity, true);
                }
            }
            class_1937 class_19372 = blockEntity.method_10997();
            if (class_19372 instanceof class_3218) {
                class_3218 level = (class_3218)class_19372;
                MagniaMoveable.sendEntityEffectParticles(level, entity, type.getEffectParticleOptions(), 1.0f);
            }
        }
    }

    private static boolean shouldOffset(MagniaSproutBlockEntity entity, class_2350 facing) {
        return facing != class_2350.field_11036 && !entity.method_10997().method_8320(entity.method_11016().method_10093(facing).method_10074()).method_26215();
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, MagniaSproutBlockEntity entity) {
        level.method_8390(class_1297.class, MagniaSproutBlockEntity.getRange(level, state, pos), MagniaMoveable::canMagniaAffect).forEach(moved -> MagniaSproutBlockEntity.doMagniaMovement(moved, entity));
    }
}

