/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.registry;

import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.client.EnderscapeClient;
import net.bunten.enderscape.client.sound.EndermanStareSoundInstance;
import net.bunten.enderscape.client.sound.EndermanStaticSoundInstance;
import net.bunten.enderscape.network.ClientboundDashJumpPayload;
import net.bunten.enderscape.network.ClientboundDashJumpSoundPayload;
import net.bunten.enderscape.network.ClientboundMirrorTeleportInfoPayload;
import net.bunten.enderscape.network.ClientboundNebuliteOreSoundPayload;
import net.bunten.enderscape.network.ClientboundRubbleShieldCooldownSoundPayload;
import net.bunten.enderscape.network.ClientboundStareOverlayPayload;
import net.bunten.enderscape.network.ClientboundStareSoundPayload;
import net.bunten.enderscape.network.ClientboundStructureChangedPayload;
import net.bunten.enderscape.network.ClientboundTransdimensionalTravelSoundPayload;
import net.bunten.enderscape.registry.EnderscapeBlockSounds;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.bunten.enderscape.registry.EnderscapeRegistries;
import net.bunten.enderscape.sound.StructureMusic;
import net.bunten.enderscape.util.BlockUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7924;

@Environment(value=EnvType.CLIENT)
public class EnderscapeClientNetworking {
    private static void receiveDashJumpPayload(ClientboundDashJumpPayload payload, ClientPlayNetworking.Context context) {
        class_310 client = context.client();
        class_746 player = client.field_1724;
        client.execute(() -> {
            if (player == null || !player.method_5805() || player.method_7325()) {
                return;
            }
            class_243 travel = new class_243((double)player.field_6212, (double)player.field_6227, (double)player.field_6250).method_1029();
            float sinYRot = class_3532.method_15374((float)(player.method_36454() * ((float)Math.PI / 180)));
            float cosYRot = class_3532.method_15362((float)(player.method_36454() * ((float)Math.PI / 180)));
            float hozPower = player.method_6128() ? payload.horizontalPower() * payload.glideVelocityFactor() : payload.horizontalPower();
            float verPower = player.method_6128() ? payload.verticalPower() * payload.glideVelocityFactor() : payload.verticalPower();
            player.method_18799(new class_243(travel.field_1352 * (double)hozPower * (double)cosYRot - travel.field_1350 * (double)hozPower * (double)sinYRot, (double)verPower, travel.field_1350 * (double)hozPower * (double)cosYRot + travel.field_1352 * (double)hozPower * (double)sinYRot));
        });
    }

    private static void receiveDashJumpSoundPayload(ClientboundDashJumpSoundPayload payload, ClientPlayNetworking.Context context) {
        class_310 client = context.client();
        client.execute(() -> {
            class_1297 entity = client.field_1687.method_8469(payload.entityId());
            if (entity != null && entity.method_5805() && !entity.method_7325()) {
                class_3414 soundEvent = (class_3414)client.field_1687.method_30349().method_30530(class_7924.field_41225).method_46747(class_5321.method_29179((class_5321)class_7924.field_41225, (class_2960)payload.soundEvent())).comp_349();
                client.field_1687.method_55116(entity, soundEvent, entity.method_5634(), 1.0f, 1.0f);
            }
        });
    }

    private static void receiveMirrorTeleportPayload(ClientboundMirrorTeleportInfoPayload payload, ClientPlayNetworking.Context context) {
        class_310 client = context.client();
        client.execute(() -> {
            EnderscapeClient.postMirrorUseTicks = 60;
        });
    }

    private static void receiveNebuliteOreSoundPayload(ClientboundNebuliteOreSoundPayload payload, ClientPlayNetworking.Context context) {
        class_310 client = context.client();
        client.execute(() -> {
            class_2338 nebulite = payload.globalPos().comp_2208();
            class_5321 dimension = payload.globalPos().comp_2207();
            class_638 level = client.field_1687;
            class_1297 entity = client.field_1719;
            if (level != null && level.method_27983() == dimension && entity instanceof class_1309) {
                class_1309 mob = (class_1309)entity;
                class_3414 sound = BlockUtil.isBlockObstructed((class_1937)level, nebulite) ? EnderscapeBlockSounds.NEBULITE_ORE_IDLE_OBSTRUCTED : (mob.method_24515().method_19771((class_2382)nebulite, 12.0) ? EnderscapeBlockSounds.NEBULITE_ORE_IDLE : EnderscapeBlockSounds.NEBULITE_ORE_IDLE_FAR);
                float range = class_3532.method_15363((float)((float)((double)nebulite.method_10264() - mob.method_23318())), (float)-8.0f, (float)0.0f) / 20.0f + class_3532.method_15344((class_5819)level.method_8409(), (float)0.9f, (float)1.1f);
                level.method_8486((double)nebulite.method_10263(), (double)nebulite.method_10264(), (double)nebulite.method_10260(), sound, class_3419.field_15245, range, range, false);
            }
        });
    }

    private static void receiveRubbleShieldCooldownSoundPayload(ClientboundRubbleShieldCooldownSoundPayload payload, ClientPlayNetworking.Context context) {
        class_310 client = context.client();
        client.execute(() -> {
            if (client.field_1724 != null) {
                client.method_1483().method_4873((class_1113)class_1109.method_47978(EnderscapeItemSounds.RUBBLE_SHIELD_COOLDOWN_OVER, (float)1.0f));
            }
        });
    }

    private static void receiveStareOverlayPayload(ClientboundStareOverlayPayload payload, ClientPlayNetworking.Context context) {
        class_310 client = context.client();
        client.execute(() -> {
            if (EnderscapeClient.stareTicks < 100) {
                EnderscapeClient.stareTicks += 2;
            }
            if ((EnderscapeClient.staticSoundInstance == null || !client.method_1483().method_4877((class_1113)EnderscapeClient.staticSoundInstance)) && EnderscapeConfig.getInstance().endermanStaticSound) {
                EnderscapeClient.staticSoundInstance = new EndermanStaticSoundInstance(client);
                client.method_1483().method_4873((class_1113)EnderscapeClient.staticSoundInstance);
            }
        });
    }

    private static void receiveStareSoundPayload(ClientboundStareSoundPayload payload, ClientPlayNetworking.Context context) {
        class_310 client = context.client();
        int entityId = payload.entityId();
        client.execute(() -> {
            if (EnderscapeClient.stareSoundInstance == null || !client.method_1483().method_4877((class_1113)EnderscapeClient.stareSoundInstance)) {
                EnderscapeClient.stareSoundInstance = new EndermanStareSoundInstance(client, entityId);
                client.method_1483().method_4873((class_1113)EnderscapeClient.stareSoundInstance);
            }
        });
    }

    private static void receiveStructureChangedPayload(ClientboundStructureChangedPayload payload, ClientPlayNetworking.Context context) {
        class_310 client = context.client();
        class_2960 location = payload.location();
        client.execute(() -> {
            if (client.field_1687 == null) {
                return;
            }
            class_2378 registry = client.field_1687.method_30349().method_30530(EnderscapeRegistries.STRUCTURE_MUSIC);
            EnderscapeClient.structureMusic = registry.method_10220().filter(music -> music.permittedStructures().contains(location)).map(StructureMusic::music).findFirst();
        });
    }

    private static void receiveTransdimensionalTravelSoundPayload(ClientboundTransdimensionalTravelSoundPayload payload, ClientPlayNetworking.Context context) {
        class_310 client = context.client();
        client.execute(() -> client.method_1483().method_4873((class_1113)class_1109.method_24877((class_3414)EnderscapeItemSounds.MIRROR_TRANSDIMENSIONAL_TRAVEL, (float)1.0f, (float)0.4f)));
    }

    static {
        ClientPlayNetworking.registerGlobalReceiver(ClientboundDashJumpPayload.TYPE, EnderscapeClientNetworking::receiveDashJumpPayload);
        ClientPlayNetworking.registerGlobalReceiver(ClientboundDashJumpSoundPayload.TYPE, EnderscapeClientNetworking::receiveDashJumpSoundPayload);
        ClientPlayNetworking.registerGlobalReceiver(ClientboundMirrorTeleportInfoPayload.TYPE, EnderscapeClientNetworking::receiveMirrorTeleportPayload);
        ClientPlayNetworking.registerGlobalReceiver(ClientboundNebuliteOreSoundPayload.TYPE, EnderscapeClientNetworking::receiveNebuliteOreSoundPayload);
        ClientPlayNetworking.registerGlobalReceiver(ClientboundRubbleShieldCooldownSoundPayload.TYPE, EnderscapeClientNetworking::receiveRubbleShieldCooldownSoundPayload);
        ClientPlayNetworking.registerGlobalReceiver(ClientboundStareOverlayPayload.TYPE, EnderscapeClientNetworking::receiveStareOverlayPayload);
        ClientPlayNetworking.registerGlobalReceiver(ClientboundStareSoundPayload.TYPE, EnderscapeClientNetworking::receiveStareSoundPayload);
        ClientPlayNetworking.registerGlobalReceiver(ClientboundStructureChangedPayload.TYPE, EnderscapeClientNetworking::receiveStructureChangedPayload);
        ClientPlayNetworking.registerGlobalReceiver(ClientboundTransdimensionalTravelSoundPayload.TYPE, EnderscapeClientNetworking::receiveTransdimensionalTravelSoundPayload);
    }
}

