/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.mixin;

import java.util.HashMap;
import java.util.Map;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.entity.magnia.MagniaMoveable;
import net.bunten.enderscape.item.MagniaAttractorItem;
import net.bunten.enderscape.item.NebuliteToolContext;
import net.bunten.enderscape.particle.MagniaParticleOptions;
import net.bunten.enderscape.registry.EnderscapeCriteria;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin
extends class_1309 {
    @Unique
    private int Enderscape$airTicks = 0;
    @Unique
    private final Map<class_1297, Integer> Enderscape$magniaTrackedEntities = new HashMap<class_1297, Integer>();
    @Unique
    private final Map<class_1297, Integer> Enderscape$pullTickCounters = new HashMap<class_1297, Integer>();

    @Shadow
    public abstract class_1661 method_31548();

    protected PlayerMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void Enderscape$tick(CallbackInfo info) {
        this.Enderscape$tickMagniaAttractorItemMovement();
        int n = this.Enderscape$airTicks = !this.method_24828() && !this.method_5799() ? this.Enderscape$airTicks + 1 : 0;
        if (this.method_6128() && this.method_5715() && EnderscapeConfig.getInstance().elytraSneakToStopGliding) {
            ((class_1657)this).method_66281();
        }
    }

    @Unique
    private void Enderscape$tickMagniaAttractorItemMovement() {
        if (this.method_5805() && !this.method_7325() && !this.method_37908().method_8608()) {
            class_1799 stack = MagniaAttractorItem.getValidAttractor(this.method_31548());
            if (!stack.method_7960() && MagniaAttractorItem.isEnabled(stack)) {
                int range = MagniaAttractorItem.getEntityPullRange(stack);
                class_238 inflated = this.method_5829().method_1009((double)range, 4.0, (double)range);
                NebuliteToolContext context = new NebuliteToolContext(stack, this.method_37908(), (class_1309)((class_1657)this));
                this.method_37908().method_18467(class_1542.class, inflated).stream().filter(item -> !item.method_6977()).forEach(entity -> this.Enderscape$pullEntity(context, (class_1297)entity, 1));
                this.method_37908().method_18467(class_1303.class, inflated).stream().filter(orb -> orb.field_6012 >= 20).forEach(entity -> this.Enderscape$pullEntity(context, (class_1297)entity, 0));
                this.Enderscape$magniaTrackedEntities.entrySet().removeIf(entry -> {
                    class_1297 item = (class_1297)entry.getKey();
                    int cooldown = (Integer)entry.getValue();
                    if (this.method_19538().method_1022(item.method_19538()) > (double)range) {
                        if (cooldown >= 20) {
                            MagniaMoveable.setMovedByMagnia(item, false);
                            return true;
                        }
                        entry.setValue(cooldown + 1);
                    } else {
                        entry.setValue(0);
                    }
                    return false;
                });
            }
            this.Enderscape$pullTickCounters.entrySet().removeIf(entry -> !MagniaMoveable.wasMovedByMagnia((class_1297)entry.getKey()));
        }
    }

    @Unique
    private void Enderscape$pullEntity(NebuliteToolContext context, class_1297 entity, int abuseCost) {
        class_3218 server;
        class_1799 stack = context.stack();
        if (!this.Enderscape$magniaTrackedEntities.containsKey(entity)) {
            if (!MagniaMoveable.wasMovedByMagnia(entity)) {
                this.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), EnderscapeItemSounds.MAGNIA_ATTRACTOR_MOVE, entity.method_5634(), 1.0f, 1.0f);
            }
            this.Enderscape$magniaTrackedEntities.put(entity, 0);
        }
        class_243 speed = this.method_19538().method_1020(entity.method_19538()).method_1029().method_1021(entity.method_5869() ? 0.04 : 0.2);
        entity.method_18799(entity.method_18798().method_1019(speed));
        MagniaMoveable.setMovedByMagnia(entity, true);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            server = (class_3218)class_19372;
            MagniaMoveable.sendEntityEffectParticles(server, entity, MagniaParticleOptions.MAGNIA_ATTRACTOR, 0.25f);
        }
        if (abuseCost > 0) {
            if (MagniaMoveable.wasMovedByMagnia(entity)) {
                int ticks = this.Enderscape$pullTickCounters.getOrDefault(entity, 0) + 1;
                if (ticks >= 40) {
                    MagniaAttractorItem.incrementEntitiesPulled(stack, abuseCost);
                    MagniaAttractorItem.tryUseFuel(context, abuseCost - MagniaAttractorItem.getTotalEntitiesPulledToUseFuel(stack, context.user()));
                    ticks = 0;
                }
                this.Enderscape$pullTickCounters.put(entity, ticks);
            } else {
                this.Enderscape$pullTickCounters.remove(entity);
            }
        }
        if ((class_19372 = context.user()) instanceof class_3222) {
            server = (class_3222)class_19372;
            EnderscapeCriteria.PULL_ENTITY.trigger((class_3222)server, entity);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tryToStartFallFlying"}, cancellable=true)
    public void Enderscape$tryToStartFallFlying(CallbackInfoReturnable<Boolean> cir) {
        if (this.Enderscape$airTicks < 1) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"startFallFlying"})
    public void Enderscape$startFallFlying(CallbackInfo info) {
        if (EnderscapeConfig.getInstance().elytraAddOpenCloseSounds && this.method_6118(class_1304.field_6174).method_31574(class_1802.field_8833)) {
            this.method_5783(EnderscapeItemSounds.ELYTRA_START_GLIDING, 1.0f, class_3532.method_15344((class_5819)this.method_59922(), (float)0.8f, (float)1.2f));
        }
        this.method_37908().method_8421((class_1297)this, (byte)-68);
    }
}

