/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.util;

import java.awt.Color;
import java.util.function.Function;
import net.bunten.enderscape.biome.util.BiomeParameters;
import net.minecraft.class_1959;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4543;
import net.minecraft.class_6880;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public record RGBA(int color, float alpha) {
    public static final double[] GAUSSIAN_SAMPLE_KERNEL = RGBA.generateGaussianKernel(2);

    public static int darkenColor(int color, float factor) {
        Color original = new Color(color);
        int r = (int)((float)original.getRed() * factor);
        int g = (int)((float)original.getGreen() * factor);
        int b = (int)((float)original.getBlue() * factor);
        return r << 16 | g << 8 | b;
    }

    public static float sampleFloat(class_4543 manager, class_243 pos, Function<BiomeParameters, Float> provided, float defaults) {
        return RGBA.sampleFloat(pos, (x, y, z) -> BiomeParameters.findFor((class_6880<class_1959>)manager.method_24854(x, y, z)).map(provided).orElse(Float.valueOf(defaults)).floatValue());
    }

    public static Vector4f sampleVector4f(class_4543 manager, class_243 pos, Function<BiomeParameters, RGBA> provided, RGBA defaults) {
        return RGBA.sampleVector4f(pos, (x, y, z) -> {
            RGBA rgba = BiomeParameters.findFor((class_6880<class_1959>)manager.method_24854(x, y, z)).map(provided).orElse(defaults);
            class_243 color = class_243.method_24457((int)rgba.color());
            return new Vector4f((float)color.field_1352, (float)color.field_1351, (float)color.field_1350, rgba.alpha());
        });
    }

    public static double[] generateGaussianKernel(int radius) {
        int i;
        int size = radius * 2 + 1;
        double[] kernel = new double[size];
        double sigma = (double)radius / 2.0;
        double sum = 0.0;
        for (i = 0; i < size; ++i) {
            double x = i - radius;
            kernel[i] = Math.exp(-0.5 * (x * x) / (sigma * sigma));
            sum += kernel[i];
        }
        i = 0;
        while (i < size) {
            int n = i++;
            kernel[n] = kernel[n] / sum;
        }
        return kernel;
    }

    public static float sampleFloat(class_243 vec3, FloatFetcher fetcher) {
        int i = class_3532.method_15357((double)vec3.method_10216());
        int j = class_3532.method_15357((double)vec3.method_10214());
        int k = class_3532.method_15357((double)vec3.method_10215());
        double d = vec3.method_10216() - (double)i;
        double e = vec3.method_10214() - (double)j;
        double f = vec3.method_10215() - (double)k;
        double g = 0.0;
        float result = 0.0f;
        int kernelSize = GAUSSIAN_SAMPLE_KERNEL.length;
        int radius = kernelSize / 2;
        for (int l = 0; l < kernelSize - 1; ++l) {
            double h = class_3532.method_16436((double)d, (double)GAUSSIAN_SAMPLE_KERNEL[l + 1], (double)GAUSSIAN_SAMPLE_KERNEL[l]);
            int m = i - radius + l;
            for (int n = 0; n < kernelSize - 1; ++n) {
                double o = class_3532.method_16436((double)e, (double)GAUSSIAN_SAMPLE_KERNEL[n + 1], (double)GAUSSIAN_SAMPLE_KERNEL[n]);
                int p = j - radius + n;
                for (int q = 0; q < kernelSize - 1; ++q) {
                    double r = class_3532.method_16436((double)f, (double)GAUSSIAN_SAMPLE_KERNEL[q + 1], (double)GAUSSIAN_SAMPLE_KERNEL[q]);
                    int s = k - radius + q;
                    double t = h * o * r;
                    g += t;
                    result += fetcher.fetch(m, p, s) * (float)t;
                }
            }
        }
        return result *= 1.0f / (float)g;
    }

    public static Vector4f sampleVector4f(class_243 vec3, Vec4Fetcher fetcher) {
        int i = class_3532.method_15357((double)vec3.method_10216());
        int j = class_3532.method_15357((double)vec3.method_10214());
        int k = class_3532.method_15357((double)vec3.method_10215());
        double d = vec3.method_10216() - (double)i;
        double e = vec3.method_10214() - (double)j;
        double f = vec3.method_10215() - (double)k;
        double g = 0.0;
        Vector4f result = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        int kernelSize = GAUSSIAN_SAMPLE_KERNEL.length;
        int radius = kernelSize / 2;
        for (int l = 0; l < kernelSize - 1; ++l) {
            double h = class_3532.method_16436((double)d, (double)GAUSSIAN_SAMPLE_KERNEL[l + 1], (double)GAUSSIAN_SAMPLE_KERNEL[l]);
            int m = i - radius + l;
            for (int n = 0; n < kernelSize - 1; ++n) {
                double o = class_3532.method_16436((double)e, (double)GAUSSIAN_SAMPLE_KERNEL[n + 1], (double)GAUSSIAN_SAMPLE_KERNEL[n]);
                int p = j - radius + n;
                for (int q = 0; q < kernelSize - 1; ++q) {
                    double r = class_3532.method_16436((double)f, (double)GAUSSIAN_SAMPLE_KERNEL[q + 1], (double)GAUSSIAN_SAMPLE_KERNEL[q]);
                    int s = k - radius + q;
                    double t = h * o * r;
                    g += t;
                    result.add((Vector4fc)fetcher.fetch(m, p, s).mul((float)t));
                }
            }
        }
        result.mul(1.0f / (float)g);
        return result;
    }

    @FunctionalInterface
    public static interface FloatFetcher {
        public float fetch(int var1, int var2, int var3);
    }

    @FunctionalInterface
    public static interface Vec4Fetcher {
        public Vector4f fetch(int var1, int var2, int var3);
    }
}

