/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.hud;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import net.bunten.enderscape.EnderscapeConfig;
import net.bunten.enderscape.client.EnderscapeClient;
import net.bunten.enderscape.client.hud.HudElement;
import net.bunten.enderscape.client.mixin.MusicManagerAccess;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_243;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5195;
import net.minecraft.class_746;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class DebugHud
extends HudElement {
    private final DecimalFormat df1 = new DecimalFormat("0.0");

    public DebugHud() {
        super(HudElement.RenderPhase.AFTER_HUD);
    }

    private String shorten(String value, String r) {
        value = value.replace(".ogg", "");
        char[] array = value.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != r.charAt(0)) continue;
            String first = String.valueOf(value.subSequence(0, i));
            value = value.replaceFirst(first, "");
            array = value.toCharArray();
            i = 0;
        }
        return value.replace(r, "");
    }

    private LinkedHashMap<List<String>, Boolean> getDebugText() {
        LinkedHashMap<List<String>, Boolean> map = new LinkedHashMap<List<String>, Boolean>();
        map.put(this.getClientInfo(), this.config.debugHudClientInfo);
        map.put(this.getMusicInfo(), this.config.debugHudMusicInfo);
        map.put(this.getPlayerInfo(), this.config.debugHudPlayerInfo);
        return map;
    }

    private List<String> getClientInfo() {
        ArrayList list = Lists.newArrayList();
        list.add("Client");
        list.add("  fps: " + this.client.method_47599());
        list.add("  guiScale: " + String.valueOf(this.client.field_1690.method_42474().method_41753()));
        list.add("  renderDistance: " + String.valueOf(this.client.field_1690.method_42503().method_41753()));
        list.add("  postMirrorUseTicks: " + EnderscapeClient.postMirrorUseTicks);
        return list;
    }

    private List<String> getMusicInfo() {
        ArrayList list = Lists.newArrayList();
        MusicManagerAccess access = (MusicManagerAccess)this.client.method_1538();
        class_1113 current = access.getCurrentMusic();
        list.add("Music");
        list.add("  Volume: " + (int)(this.client.field_1690.method_1630(class_3419.field_15253) * 100.0f) + "%");
        list.add("  Playing: " + this.client.method_1483().method_4877(current));
        list.add("  Current event: " + (current != null ? this.shorten(current.method_4775().method_12832(), ".") : "null"));
        list.add("  Current track: " + (current != null ? this.shorten(current.method_4776().method_4766().method_12832(), "/") : "null"));
        class_5195 music = this.client.method_1544().comp_3344();
        if (music != null) {
            list.add("  Next event: " + this.shorten(((class_3414)music.comp_4358().comp_349()).comp_3319().method_12832(), "."));
            list.add("    getMinDelay: " + music.comp_4359());
            list.add("    getMaxDelay: " + music.comp_4360());
            list.add("    replaceCurrentMusic: " + music.comp_4361());
            list.add("  Playing next event: " + this.client.method_1538().method_4860(music));
        }
        list.add("  Delay: " + access.getNextSongDelay() + " (" + String.format("%02d", access.getNextSongDelay() / 20 / 60) + ":" + String.format("%02d", access.getNextSongDelay() / 20 % 60) + ")");
        return list;
    }

    private List<String> getPlayerInfo() {
        class_746 player = this.client.field_1724;
        ArrayList list = Lists.newArrayList();
        if (this.client.field_1687 != null && player != null) {
            class_243 vel = player.method_5765() ? Objects.requireNonNull(player.method_5854()).method_18798() : player.method_18798();
            list.add("Player");
            list.add("  BlockPos: " + player.method_24515().method_23854());
            list.add("  Dimension: " + player.method_37908().method_27983().method_29177().toString());
            float f = (float)(player.method_23317() - 0.0);
            float h = (float)(player.method_23321() - 0.0);
            list.add("  Center Distance: " + (int)class_3532.method_15355((float)(f * f + h * h)));
            list.add("  Velocity");
            list.add("    x: " + this.df1.format(vel.field_1352));
            list.add("    y: " + this.df1.format(vel.field_1351));
            list.add("    z: " + this.df1.format(vel.field_1350));
            list.add("    lengthSqr: " + this.df1.format(vel.method_1027()));
            list.add("    horizontalDistanceSqr: " + this.df1.format(vel.method_37268()));
            list.add("  fallDistance: " + (int)player.field_6017);
            list.add("  XY Rotation: " + (int)class_3532.method_15393((float)player.method_36455()) + " / " + (int)class_3532.method_15393((float)player.method_36454()));
        }
        return list;
    }

    public String getLongestString(List<String> list) {
        String longest = "";
        for (String string : list) {
            if (string.length() <= longest.length()) continue;
            longest = string;
        }
        return longest;
    }

    @Override
    public void render(class_332 graphics, class_9779 delta) {
        if (this.client.field_1724 == null || this.client.method_53526().method_53536() || this.client.field_1690.field_1842 || !EnderscapeConfig.getInstance().debugHudEnabled) {
            return;
        }
        graphics.method_51448().pushMatrix();
        float total = switch ((Integer)this.client.field_1690.method_42474().method_41753()) {
            case 3 -> 0.6666f;
            case 4 -> 0.5f;
            default -> 1.0f;
        };
        graphics.method_51448().scale(total, total);
        int x = 2;
        int y = 2;
        for (List<String> list : this.getDebugText().keySet()) {
            if (!this.getDebugText().get(list).booleanValue()) continue;
            graphics.method_25294(x, y, x + this.client.field_1772.method_1727(this.getLongestString(list)) + 10, y + list.size() * 12 + 4, 1325739616);
            for (String string : list) {
                if (!string.isEmpty()) {
                    graphics.method_25303(this.client.field_1772, string, x + 4, y + 4, -268435457);
                }
                y += 12;
            }
            y += 6;
        }
        graphics.method_51448().popMatrix();
    }
}

