/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.hud;

import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.client.hud.HudElement;
import net.bunten.enderscape.item.MirrorContext;
import net.bunten.enderscape.item.MirrorItem;
import net.bunten.enderscape.item.NebuliteToolContext;
import net.bunten.enderscape.item.NebuliteToolItem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class NebuliteToolHud
extends HudElement {
    private static final class_2960[] EMPTY_SEGMENTS = new class_2960[]{Enderscape.id("nebulite_tool/hud/empty_segments/start"), Enderscape.id("nebulite_tool/hud/empty_segments/loop"), Enderscape.id("nebulite_tool/hud/empty_segments/end")};
    private static final class_2960[] FUELED_SEGMENTS = new class_2960[]{Enderscape.id("nebulite_tool/hud/fueled_segments/start"), Enderscape.id("nebulite_tool/hud/fueled_segments/loop"), Enderscape.id("nebulite_tool/hud/fueled_segments/end")};
    private static final class_2960[] INVALID_OVERLAY_SEGMENTS = new class_2960[]{Enderscape.id("nebulite_tool/hud/invalid_overlay_segments/start"), Enderscape.id("nebulite_tool/hud/invalid_overlay_segments/loop"), Enderscape.id("nebulite_tool/hud/invalid_overlay_segments/end")};
    private static final class_2960 TRANSDIMENSIONAL_OUTLINE = Enderscape.id("nebulite_tool/hud/transdimensional_outline");
    private static final class_2960 COST_OVERLAY_SEGMENT = Enderscape.id("nebulite_tool/hud/cost_overlay_segment");
    private float heightOffset = 0.0f;
    private float totalAlpha = 0.0f;
    private float costAlpha = 0.0f;
    private int costDisplayTicks = 0;
    private float invalidAlpha = 0.0f;
    private int invalidDisplayTicks = 0;
    private float transdimensionalAlpha = 0.0f;
    private int transdimensionalDisplayTicks = 0;
    private int costOverlayPosition = -1;
    private int fuel;
    private int maxFuel;
    private int cost;

    public NebuliteToolHud() {
        super(HudElement.RenderPhase.AFTER_HUD);
    }

    @Override
    public void render(class_332 graphics, class_9779 delta) {
        if (!this.config.nebuliteToolHudEnabled || this.client.field_1724 == null || this.client.field_1690.field_1842 || this.totalAlpha <= 0.01f || !this.client.field_1690.method_31044().method_31034() || this.client.field_1724.method_7325()) {
            return;
        }
        graphics.method_51448().pushMatrix();
        graphics.method_51448().translate(0.0f, this.heightOffset);
        float opacity = this.totalAlpha * (float)this.config.nebuliteToolHudOpacity / 100.0f;
        int x = graphics.method_51421() / 2 - (11 * this.maxFuel + 1) / 2;
        int y = graphics.method_51443() / 2 - 13 - this.config.nebuliteToolHudOffset;
        this.renderFuelBar(graphics, x, y, opacity);
        this.renderTransdimensionalOutline(graphics, x, y, opacity);
        this.renderInvalidOverlay(graphics, x, y, opacity);
        this.renderCostOverlay(graphics, y, opacity);
        graphics.method_51448().popMatrix();
    }

    private void renderFuelBar(class_332 graphics, int x, int y, float opacity) {
        int lastFueled = -1;
        int rx = x;
        for (int i = 0; i < this.maxFuel; ++i) {
            class_2960[] segments;
            boolean isFueled;
            boolean bl = isFueled = i < this.fuel;
            if (i > 0) {
                rx += 11;
            }
            if (isFueled) {
                lastFueled = rx;
            }
            class_2960[] class_2960Array = segments = isFueled ? FUELED_SEGMENTS : EMPTY_SEGMENTS;
            int index = i == 0 ? 0 : (i == this.maxFuel - 1 ? 2 : 1);
            int width = i == this.maxFuel - 1 ? 12 : 11;
            graphics.method_52707(class_10799.field_56883, segments[index], rx, y, width, 5, this.white(opacity));
        }
        this.costOverlayPosition = lastFueled;
    }

    private void renderTransdimensionalOutline(class_332 graphics, int x, int y, float opacity) {
        graphics.method_52707(class_10799.field_56883, TRANSDIMENSIONAL_OUTLINE, x - 6, y - 6, this.maxFuel * 11 + 13, 17, this.white(this.transdimensionalAlpha * opacity));
    }

    private void renderInvalidOverlay(class_332 graphics, int x, int y, float opacity) {
        int rx = x;
        for (int i = 0; i < this.maxFuel; ++i) {
            if (i > 0) {
                rx += 11;
            }
            int index = i == 0 ? 0 : (i == this.maxFuel - 1 ? 2 : 1);
            int width = i == this.maxFuel - 1 ? 12 : 11;
            graphics.method_52707(class_10799.field_56883, INVALID_OVERLAY_SEGMENTS[index], rx, y, width, 5, this.white(this.invalidAlpha * opacity));
        }
    }

    private void renderCostOverlay(class_332 graphics, int y, float opacity) {
        if (this.costAlpha > 0.0f && this.costOverlayPosition >= 0 && this.fuel >= this.cost) {
            for (int i = 0; i < this.cost; ++i) {
                graphics.method_52707(class_10799.field_56883, COST_OVERLAY_SEGMENT, this.costOverlayPosition - i * 11, y, 11, 5, this.white(this.costAlpha * opacity));
            }
        }
    }

    @Override
    public void tick() {
        class_746 player = this.client.field_1724;
        if (player == null) {
            return;
        }
        class_1799 stack = NebuliteToolItem.is(player.method_6047()) ? player.method_6047() : player.method_6079();
        NebuliteToolContext context = new NebuliteToolContext(stack, player.method_37908(), (class_1309)player);
        boolean displayUI = NebuliteToolItem.is(stack) && ((NebuliteToolItem)((Object)context.item())).displayHudWhen(context) && !player.method_7325() && player.method_6030().method_7960();
        boolean displayOutline = NebuliteToolItem.is(stack) && !((NebuliteToolItem)((Object)context.item())).hideInvalidOutlineWhen(context);
        boolean displayTransdimensional = false;
        if (MirrorItem.is(stack)) {
            MirrorContext mirrorContext = MirrorContext.of(context);
            boolean bl = displayTransdimensional = MirrorItem.hasTransdimensional(mirrorContext) && !MirrorItem.isSameDimension(mirrorContext, mirrorContext.linkedDimension()) && !displayOutline;
        }
        if (displayUI) {
            this.fuel = NebuliteToolItem.currentFuel(stack);
            this.maxFuel = NebuliteToolItem.maxFuel(stack);
            this.cost = NebuliteToolItem.of(stack).fuelCost(context);
            this.totalAlpha = class_3532.method_16439((float)0.5f, (float)this.totalAlpha, (float)1.0f);
            this.heightOffset = class_3532.method_16439((float)0.5f, (float)this.heightOffset, (float)-3.0f);
        } else {
            this.totalAlpha = class_3532.method_16439((float)0.5f, (float)this.totalAlpha, (float)0.0f);
            this.heightOffset = class_3532.method_16439((float)0.5f, (float)this.heightOffset, (float)0.0f);
        }
        this.invalidAlpha = class_3532.method_16439((float)0.35f, (float)this.invalidAlpha, (float)(displayUI && displayOutline ? class_3532.method_15363((float)(class_3532.method_15374((float)((float)this.invalidDisplayTicks * 0.4f)) * 0.5f + 0.5f), (float)0.75f, (float)1.0f) : 0.0f));
        this.costAlpha = class_3532.method_16439((float)0.35f, (float)this.costAlpha, (float)(displayUI && !displayOutline ? class_3532.method_15363((float)(class_3532.method_15374((float)((float)this.costDisplayTicks * 0.25f)) * 0.2f + 0.5f), (float)0.75f, (float)1.0f) : 0.0f));
        this.transdimensionalAlpha = class_3532.method_16439((float)0.35f, (float)this.transdimensionalAlpha, (float)(displayUI && displayTransdimensional ? class_3532.method_15363((float)(class_3532.method_15374((float)((float)this.transdimensionalDisplayTicks * 0.1f)) * 0.5f + 0.5f), (float)0.4f, (float)1.0f) : 0.0f));
        this.invalidDisplayTicks = this.invalidAlpha > 0.0f ? this.invalidDisplayTicks + 1 : 0;
        this.costDisplayTicks = this.costAlpha > 0.0f ? this.costDisplayTicks + 1 : 0;
        this.transdimensionalDisplayTicks = this.transdimensionalAlpha > 0.0f ? this.transdimensionalDisplayTicks + 1 : 0;
    }
}

