/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client.world;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.EnderscapeConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_1959;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_638;
import net.minecraft.class_6491;
import net.minecraft.class_7833;
import net.minecraft.class_9779;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

@Environment(value=EnvType.CLIENT)
public class EnderscapeSkybox {
    public static final class_7833 SKY_ROTATION_AXIS = class_7833.field_40716;
    public static float fogStartDensity = 1.0f;
    public static float fogEndDensity = 1.0f;
    public static Vector4f nebulaColor = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    public static Vector4f starColor = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    public static Vector4f flashColor = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    public static final RenderPipeline NEBULAE_PIPELINE = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_60125}).withLocation(Enderscape.id("pipeline/nebulae")).withVertexShader("core/position_tex").withFragmentShader("core/position_tex").withSampler("Sampler0").withBlend(BlendFunction.TRANSLUCENT).withDepthWrite(false).withVertexFormat(class_290.field_1585, VertexFormat.class_5596.field_27382).build());
    private static final RenderSystem.class_5590 starIndices = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
    private static int starIndexCount;
    private static final NebulaData sky;
    private static final NebulaData nebula1;
    private static final NebulaData nebula2;
    private static final GpuBuffer stars;

    public static float gammaFactor() {
        if (!EnderscapeConfig.getInstance().skyboxScalesBrightnessWithGamma) {
            return 1.0f;
        }
        float gamma = ((Double)class_310.method_1551().field_1690.method_42473().method_41753()).floatValue();
        float scale = (float)EnderscapeConfig.getInstance().skyboxBrightnessScaleFactor / 100.0f;
        return 1.0f + gamma * scale;
    }

    private static Vector4f computeSkyColor(class_4184 camera, class_638 level) {
        class_243 position = camera.method_19326().method_1023(2.0, 2.0, 2.0).method_1021(0.25);
        class_243 skyColor = class_6491.method_24895((class_243)position, (ix, jx, k) -> class_243.method_24457((int)((class_1959)level.method_22385().method_24854(ix, jx, k).comp_349()).method_8697())).method_1021((double)EnderscapeSkybox.gammaFactor());
        return new Vector4f((float)skyColor.method_10216(), (float)skyColor.method_10214(), (float)skyColor.method_10215(), 1.0f);
    }

    public static void render(class_4587 pose, class_638 level, class_4184 camera, class_9779 tracker) {
        float gameTime = ((float)level.method_8510() + tracker.method_60636()) % 360000.0f;
        float baseSpeed = gameTime * 3.0E-5f;
        EnderscapeSkybox.renderSkybox(pose, EnderscapeSkybox.computeSkyColor(camera, level), baseSpeed);
        EnderscapeSkybox.renderNebulae(pose, nebulaColor, baseSpeed * 5.0f);
        EnderscapeSkybox.renderStars(pose, starColor, baseSpeed * 10.0f);
    }

    private static NebulaData createSkyBuffer() {
        try (class_9799 byteBufferBuilder = new class_9799(24 * class_290.field_1575.getVertexSize());){
            NebulaData nebulaData;
            block19: {
                class_287 bufferBuilder = new class_287(byteBufferBuilder, VertexFormat.class_5596.field_27382, class_290.field_1575);
                for (int i = 0; i < 6; ++i) {
                    Matrix4f matrix4f = new Matrix4f();
                    switch (i) {
                        case 1: {
                            matrix4f.rotationX(1.5707964f);
                            break;
                        }
                        case 2: {
                            matrix4f.rotationX(-1.5707964f);
                            break;
                        }
                        case 3: {
                            matrix4f.rotationX((float)Math.PI);
                            break;
                        }
                        case 4: {
                            matrix4f.rotationZ(1.5707964f);
                            break;
                        }
                        case 5: {
                            matrix4f.rotationZ(-1.5707964f);
                        }
                    }
                    bufferBuilder.method_22918(matrix4f, -100.0f, -100.0f, -100.0f).method_22913(0.0f, 0.0f).method_39415(-1);
                    bufferBuilder.method_22918(matrix4f, -100.0f, -100.0f, 100.0f).method_22913(0.0f, 16.0f).method_39415(-1);
                    bufferBuilder.method_22918(matrix4f, 100.0f, -100.0f, 100.0f).method_22913(16.0f, 16.0f).method_39415(-1);
                    bufferBuilder.method_22918(matrix4f, 100.0f, -100.0f, -100.0f).method_22913(16.0f, 0.0f).method_39415(-1);
                }
                class_9801 mesh = bufferBuilder.method_60800();
                try {
                    GpuBuffer buffer = RenderSystem.getDevice().createBuffer(() -> "End sky vertex buffer", 40, mesh.method_60818());
                    nebulaData = new NebulaData(buffer, mesh.method_60822().comp_751());
                    if (mesh == null) break block19;
                }
                catch (Throwable throwable) {
                    if (mesh != null) {
                        try {
                            mesh.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                mesh.close();
            }
            return nebulaData;
        }
    }

    private static void renderSkybox(class_4587 pose, Vector4f color, float angle) {
        Matrix4fStack matrix = RenderSystem.getModelViewStack();
        matrix.pushMatrix();
        matrix.mul((Matrix4fc)pose.method_23760().method_23761());
        matrix.mul((Matrix4fc)new Matrix4f().rotation((Quaternionfc)SKY_ROTATION_AXIS.rotation(angle)));
        class_1044 texture = class_310.method_1551().method_1531().method_4619(Enderscape.id("textures/environment/sky.png"));
        texture.method_70950(false);
        RenderSystem.class_5590 buffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        GpuTextureView colorView = class_310.method_1551().method_1522().method_71639();
        GpuTextureView textureView = class_310.method_1551().method_1522().method_71640();
        GpuBufferSlice slice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)color, (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
        GpuBuffer skyBuffer = buffer.method_68274(sky.indexCount());
        VertexFormat.class_5595 type = buffer.method_31924();
        try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "End sky box", colorView, OptionalInt.empty(), textureView, OptionalDouble.empty());){
            pass.setPipeline(class_10799.field_56875);
            RenderSystem.bindDefaultUniforms((RenderPass)pass);
            pass.setUniform("DynamicTransforms", slice);
            pass.bindSampler("Sampler0", texture.method_71659());
            pass.setVertexBuffer(0, sky.buffer());
            pass.setIndexBuffer(skyBuffer, type);
            pass.drawIndexed(0, 0, sky.indexCount(), 1);
        }
        matrix.popMatrix();
    }

    private static NebulaData createNebulaeBuffer(double minSize, double maxSize, int count, long seed) {
        class_5820 random = new class_5820(seed);
        try (class_9799 byteBufferBuilder = new class_9799(class_290.field_1585.getVertexSize() * count * 4);){
            NebulaData nebulaData;
            block13: {
                class_287 builder = new class_287(byteBufferBuilder, VertexFormat.class_5596.field_27382, class_290.field_1585);
                for (int i = 0; i < count; ++i) {
                    double posX = random.method_43058() * 2.0 - 1.0;
                    double posY = random.method_43058() - 0.5;
                    double posZ = random.method_43058() * 2.0 - 1.0;
                    double size = class_3532.method_15366((class_5819)random, (double)minSize, (double)maxSize);
                    double length = posX * posX + posY * posY + posZ * posZ;
                    double distance = 2.0;
                    if (!(length < 1.0) || !(length > 0.001)) continue;
                    length = distance / Math.sqrt(length);
                    size *= distance;
                    double px = (posX *= length) * 100.0;
                    double py = (posY *= length) * 100.0;
                    double pz = (posZ *= length) * 100.0;
                    double angle = Math.atan2(posX, posZ);
                    double sin1 = Math.sin(angle);
                    double cos1 = Math.cos(angle);
                    angle = Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
                    double sin2 = Math.sin(angle);
                    double cos2 = Math.cos(angle);
                    angle = random.method_43058() * Math.PI * 2.0;
                    double sin3 = Math.sin(angle);
                    double cos3 = Math.cos(angle);
                    for (int index = 0; index < 4; ++index) {
                        double x = (double)((index & 2) - 1) * size;
                        double y = (double)((index + 1 & 2) - 1) * size;
                        double aa = x * cos3 - y * sin3;
                        double ab = y * cos3 + x * sin3;
                        double dy = aa * sin2 + 0.0 * cos2;
                        double ae = 0.0 * sin2 - aa * cos2;
                        double dx = ae * sin1 - ab * cos1;
                        double dz = ab * sin1 + ae * cos1;
                        float texU = index >> 1 & 1;
                        float texV = index + 1 >> 1 & 1;
                        builder.method_22912((float)(px + dx), (float)(py + dy), (float)(pz + dz)).method_22913(texU, texV);
                    }
                }
                class_9801 mesh = builder.method_60800();
                try {
                    GpuBuffer buffer = RenderSystem.getDevice().createBuffer(() -> "Nebulae vertex buffer", 40, mesh.method_60818());
                    nebulaData = new NebulaData(buffer, mesh.method_60822().comp_751());
                    if (mesh == null) break block13;
                }
                catch (Throwable throwable) {
                    if (mesh != null) {
                        try {
                            mesh.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                mesh.close();
            }
            return nebulaData;
        }
    }

    private static void renderNebulae(class_4587 pose, Vector4f color, float angle) {
        Matrix4fStack matrix = RenderSystem.getModelViewStack();
        matrix.pushMatrix();
        matrix.mul((Matrix4fc)pose.method_23760().method_23761());
        matrix.mul((Matrix4fc)new Matrix4f().rotation((Quaternionfc)SKY_ROTATION_AXIS.rotation(angle)));
        EnderscapeSkybox.drawIndividualNebulae(nebula1, color, Enderscape.id("textures/environment/nebula1.png"));
        EnderscapeSkybox.drawIndividualNebulae(nebula2, color, Enderscape.id("textures/environment/nebula2.png"));
        matrix.popMatrix();
    }

    private static void drawIndividualNebulae(NebulaData data, Vector4f color, class_2960 id) {
        Matrix4fStack matrix = RenderSystem.getModelViewStack();
        GpuTextureView colorView = class_310.method_1551().method_1522().method_71639();
        GpuTextureView depthView = class_310.method_1551().method_1522().method_71640();
        class_1044 texture = class_310.method_1551().method_1531().method_4619(id);
        texture.method_70950(false);
        GpuBufferSlice slice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)matrix, (Vector4fc)color, (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
        RenderSystem.class_5590 buffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        GpuBuffer nebulaeBuffer = buffer.method_68274(data.indexCount());
        VertexFormat.class_5595 type = buffer.method_31924();
        try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "End sky nebulae", colorView, OptionalInt.empty(), depthView, OptionalDouble.empty());){
            pass.setPipeline(NEBULAE_PIPELINE);
            pass.setUniform("DynamicTransforms", slice);
            pass.bindSampler("Sampler0", texture.method_71659());
            pass.setVertexBuffer(0, data.buffer());
            pass.setIndexBuffer(nebulaeBuffer, type);
            pass.drawIndexed(0, 0, data.indexCount(), 1);
        }
    }

    private static GpuBuffer createStarsBuffer(int count, float minSize, float maxSize) {
        GpuBuffer buffer;
        class_5819 random = class_5819.method_43049((long)10842L);
        float distance = 100.0f;
        try (class_9799 builder = class_9799.method_72201((int)(class_290.field_1592.getVertexSize() * count * 4));){
            class_287 buf = new class_287(builder, VertexFormat.class_5596.field_27382, class_290.field_1592);
            for (int i = 0; i < count; ++i) {
                float x = random.method_43057() * 2.0f - 1.0f;
                float y = random.method_43057() * 2.0f - 1.0f;
                float z = random.method_43057() * 2.0f - 1.0f;
                float size = class_3532.method_32750((class_5819)random, (float)minSize, (float)maxSize);
                float lenSq = class_3532.method_60677((float)x, (float)y, (float)z);
                if (lenSq <= 0.010000001f || lenSq >= 1.0f) continue;
                Vector3f dir = new Vector3f(x, y, z).normalize(distance);
                float rotation = (float)(random.method_43058() * Math.PI * 2.0);
                Matrix3f mat = new Matrix3f().rotateTowards((Vector3fc)new Vector3f((Vector3fc)dir).negate(), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)).rotateZ(-rotation);
                buf.method_60830(new Vector3f(size, -size, 0.0f).mul((Matrix3fc)mat).add((Vector3fc)dir));
                buf.method_60830(new Vector3f(size, size, 0.0f).mul((Matrix3fc)mat).add((Vector3fc)dir));
                buf.method_60830(new Vector3f(-size, size, 0.0f).mul((Matrix3fc)mat).add((Vector3fc)dir));
                buf.method_60830(new Vector3f(-size, -size, 0.0f).mul((Matrix3fc)mat).add((Vector3fc)dir));
            }
            try (class_9801 mesh = buf.method_60800();){
                starIndexCount = mesh.method_60822().comp_751();
                buffer = RenderSystem.getDevice().createBuffer(() -> "Stars vertex buffer", 40, mesh.method_60818());
            }
        }
        return buffer;
    }

    private static void renderStars(class_4587 pose, Vector4f color, float angle) {
        Matrix4fStack matrix = RenderSystem.getModelViewStack();
        matrix.pushMatrix();
        matrix.mul((Matrix4fc)pose.method_23760().method_23761());
        matrix.mul((Matrix4fc)new Matrix4f().rotation((Quaternionfc)SKY_ROTATION_AXIS.rotation(angle)));
        GpuTextureView colorView = class_310.method_1551().method_1522().method_71639();
        GpuTextureView depthView = class_310.method_1551().method_1522().method_71640();
        GpuBufferSlice slice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)matrix, (Vector4fc)color, (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
        GpuBuffer starBuffer = starIndices.method_68274(starIndexCount);
        VertexFormat.class_5595 type = starIndices.method_31924();
        try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "End sky stars", colorView, OptionalInt.empty(), depthView, OptionalDouble.empty());){
            pass.setPipeline(class_10799.field_56877);
            RenderSystem.bindDefaultUniforms((RenderPass)pass);
            pass.setUniform("DynamicTransforms", slice);
            pass.setVertexBuffer(0, stars);
            pass.setIndexBuffer(starBuffer, type);
            pass.drawIndexed(0, 0, starIndexCount, 1);
        }
        matrix.popMatrix();
    }

    static {
        sky = EnderscapeSkybox.createSkyBuffer();
        nebula1 = EnderscapeSkybox.createNebulaeBuffer(16.0, 64.0, 60, 2L);
        nebula2 = EnderscapeSkybox.createNebulaeBuffer(16.0, 64.0, 60, 3L);
        stars = EnderscapeSkybox.createStarsBuffer(1500, 0.05f, 0.25f);
    }

    private record NebulaData(GpuBuffer buffer, int indexCount) {
    }
}

