/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.drifter;

import net.bunten.enderscape.entity.ai.behavior.DrifterStartOrStopLeakingJelly;
import net.bunten.enderscape.entity.drifter.AbstractDrifter;
import net.bunten.enderscape.registry.EnderscapeCriteria;
import net.bunten.enderscape.registry.EnderscapeDamageTypes;
import net.bunten.enderscape.registry.EnderscapeEntities;
import net.bunten.enderscape.registry.EnderscapeEntitySounds;
import net.bunten.enderscape.registry.EnderscapeGameEvents;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.bunten.enderscape.registry.EnderscapeStats;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class Drifter
extends AbstractDrifter {
    private static final String DRIPPING_JELLY_KEY = "DrippingJelly";
    private static final class_2940<Boolean> DRIPPING_JELLY = class_2945.method_12791(Drifter.class, (class_2941)class_2943.field_13323);

    public Drifter(class_1299<? extends Drifter> type, class_1937 world) {
        super(type, world);
        DrifterStartOrStopLeakingJelly.refreshCooldown(this);
    }

    public static class_5132.class_5133 createAttributes() {
        return Drifter.createBaseDrifterAttributes().method_26868(class_5134.field_23716, 16.0).method_26868(class_5134.field_23720, 0.4);
    }

    public boolean isDrippingJelly() {
        return (Boolean)this.field_6011.method_12789(DRIPPING_JELLY);
    }

    public void setDrippingJelly(boolean value) {
        this.field_6011.method_12778(DRIPPING_JELLY, (Object)value);
    }

    protected class_243 getEntityBounceVelocity(class_1309 mob) {
        class_243 vel = mob.method_18798();
        float boost = mob.method_6128() ? 1.5f : 1.0f;
        double height = 1.6;
        if (mob.method_6128()) {
            height += 0.4;
        }
        if (mob.method_5715()) {
            height /= 2.0;
        }
        return new class_243(vel.field_1352 * (double)boost, height, vel.field_1350 * (double)boost);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DRIPPING_JELLY, (Object)false);
    }

    protected void method_5652(class_11372 output) {
        super.method_5652(output);
        output.method_71472(DRIPPING_JELLY_KEY, this.isDrippingJelly());
    }

    protected void method_5749(class_11368 input) {
        super.method_5749(input);
        this.setDrippingJelly(input.method_71433(DRIPPING_JELLY_KEY, false));
    }

    @Override
    public class_3414 getJumpSound() {
        return EnderscapeEntitySounds.DRIFTER_JUMP;
    }

    private boolean hasFeatherFalling(class_1309 mob) {
        try {
            class_2378 registry = this.method_37908().method_30349().method_46759(class_7924.field_41265).orElse(null);
            if (registry == null) {
                return false;
            }
            class_1887 enchantment = (class_1887)registry.method_29107(class_1893.field_9129);
            if (enchantment == null) {
                return false;
            }
            class_6880 holder = registry.method_47983((Object)enchantment);
            return class_1890.method_8225((class_6880)holder, (class_1799)mob.method_6118(class_1304.field_6166)) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void method_6007() {
        class_1937 class_19372;
        super.method_6007();
        if (this.method_5805() && !this.method_37908().method_8608()) {
            this.method_37908().method_8335((class_1297)this, this.getBounceHitbox()).forEach(entity -> {
                class_1309 mob;
                if (entity instanceof class_1309 && (mob = (class_1309)entity).method_5805() && !mob.method_7325() && !(mob instanceof AbstractDrifter)) {
                    this.collide(mob, this.getBounceHitbox());
                }
            });
        }
        if ((class_19372 = this.method_37908()) instanceof class_3218) {
            class_243 pos;
            class_3218 server = (class_3218)class_19372;
            if (this.method_6479() && !this.isDrippingJelly() && this.field_5974.method_43048(8) == 0) {
                pos = this.method_19538();
                server.method_65096((class_2394)EnderscapeParticles.DRIFT_JELLY_DRIPPING, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 1, (double)0.4f, 1.0, (double)0.4f, 0.1);
            }
            if (this.isDrippingJelly() && this.field_5974.method_43056()) {
                pos = this.method_19538();
                server.method_65096((class_2394)EnderscapeParticles.DRIFT_JELLY_DRIPPING, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 1, (double)0.4f, 1.0, (double)0.4f, 0.1);
            }
        }
    }

    @NotNull
    public class_238 getBounceHitbox() {
        return this.method_5829().method_1009(0.25, 0.0, 0.25).method_35580(0.0, 0.85, 0.0).method_989(0.0, 1.0, 0.0);
    }

    private void collide(class_1309 mob, class_238 bounceHitbox) {
        boolean isLeashOwner;
        boolean bl = isLeashOwner = this.method_60953() && this.method_60955().field_52217 == mob;
        if (!mob.method_24828() && !isLeashOwner && mob.method_18798().field_1351 < (double)-0.1f && bounceHitbox.method_994(mob.method_5829())) {
            class_243 velocity = new class_243(mob.method_18798().field_1352, mob.method_5715() ? -0.4 : 0.6, mob.method_18798().field_1350);
            this.method_18799(velocity);
            mob.method_18799(this.getEntityBounceVelocity(mob));
            this.method_32875((class_6880)EnderscapeGameEvents.BOUNCE, (class_1297)mob);
            if (mob instanceof class_3222) {
                class_3222 player = (class_3222)mob;
                EnderscapeCriteria.BOUNCE_ON_DRIFTER.trigger(player, this);
                player.method_7281(EnderscapeStats.DRIFTER_BOUNCE);
                player.field_13987.method_14364((class_2596)new class_2743((class_1297)mob));
            }
            mob.field_6017 = 0.0;
            this.method_5783(EnderscapeEntitySounds.DRIFTER_BOUNCE, 1.0f, 1.0f);
            this.method_64419(this.method_37908().method_48963().method_48796(EnderscapeDamageTypes.STOMP, (class_1297)mob), this.hasFeatherFalling(mob) ? 0.0f : 1.0f);
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_31574(class_1802.field_8469) && this.isDrippingJelly()) {
            if (!this.method_37908().method_8608()) {
                stack.method_57008(1, (class_1309)player);
                class_1799 jelly = new class_1799((class_1935)EnderscapeItems.DRIFT_JELLY_BOTTLE);
                if (!player.method_31548().method_7394(jelly)) {
                    player.method_7328(jelly, false);
                }
                this.method_32875((class_6880)class_5712.field_28725, (class_1297)player);
                this.method_5783(EnderscapeEntitySounds.DRIFTER_MILK, 0.5f, 1.0f);
                this.setDrippingJelly(false);
                DrifterStartOrStopLeakingJelly.refreshCooldown(this);
                return class_1269.field_52422;
            }
            return class_1269.field_21466;
        }
        return super.method_5992(player, hand);
    }

    public void method_24650(class_3218 world, class_1429 other) {
        super.method_24650(world, other);
        if (!world.method_8608()) {
            ((Drifter)other).setDrippingJelly(true);
            this.setDrippingJelly(true);
        }
    }

    protected class_3414 method_5994() {
        return EnderscapeEntitySounds.DRIFTER_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        class_1309 mob;
        class_1297 class_12972;
        if (source.method_49708(EnderscapeDamageTypes.STOMP) && (class_12972 = source.method_5529()) instanceof class_1309 && this.hasFeatherFalling(mob = (class_1309)class_12972)) {
            return EnderscapeEntitySounds.DRIFTER_HURT_SILENT;
        }
        return EnderscapeEntitySounds.DRIFTER_HURT;
    }

    protected class_3414 method_6002() {
        return EnderscapeEntitySounds.DRIFTER_DEATH;
    }

    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)EnderscapeEntities.DRIFTLET.method_5883((class_1937)world, class_3730.field_16466);
    }

    public void method_7217(boolean baby) {
    }
}

