/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.entity.rustle;

import com.mojang.serialization.Dynamic;
import net.bunten.enderscape.entity.ai.EnderscapeMemory;
import net.bunten.enderscape.entity.rustle.RustleAI;
import net.bunten.enderscape.registry.EnderscapeEntities;
import net.bunten.enderscape.registry.EnderscapeEntityLootTables;
import net.bunten.enderscape.registry.EnderscapeEntitySounds;
import net.bunten.enderscape.registry.EnderscapeItemSounds;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.bunten.enderscape.registry.EnderscapeParticles;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.bunten.enderscape.registry.tag.EnderscapeItemTags;
import net.bunten.enderscape.registry.tag.EnderscapePoiTags;
import net.minecraft.class_10209;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1820;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5147;
import net.minecraft.class_5328;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5761;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class Rustle
extends class_1429
implements class_5761,
class_5147 {
    private static final class_2940<Byte> DATA_FLAGS_ID = class_2945.method_12791(Rustle.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> FROM_BUCKET = class_2945.method_12791(Rustle.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SLEEPING = class_2945.method_12791(Rustle.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SHEARED = class_2945.method_12791(Rustle.class, (class_2941)class_2943.field_13323);
    public final class_7094 sleepingAnimationState = new class_7094();
    private long lastBumpTimestamp = 0L;
    private static final long BUMP_COOLDOWN_TIME = 20L;

    public Rustle(class_1299<? extends Rustle> type, class_1937 world) {
        super(type, world);
        this.method_5941(class_7.field_18, -1.0f);
    }

    public static class_5132.class_5133 createAttributes() {
        return Rustle.method_61457().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.13).method_26868(class_5134.field_49079, 3.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_FLAGS_ID, (Object)0);
        builder.method_56912(FROM_BUCKET, (Object)false);
        builder.method_56912(SLEEPING, (Object)false);
        builder.method_56912(SHEARED, (Object)false);
    }

    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
    }

    protected void method_5652(class_11372 output) {
        super.method_5652(output);
        output.method_71472("FromBucket", this.method_6453());
        output.method_71472("Sleeping", this.method_6113());
        output.method_71472("Sheared", this.isSheared());
    }

    protected void method_5749(class_11368 input) {
        super.method_5749(input);
        this.method_6454(input.method_71433("FromBucket", false));
        this.setSleeping(input.method_71433("Sleeping", false));
        this.setSheared(input.method_71433("Sheared", false));
    }

    public void method_6455(class_1799 stack) {
        class_5761.method_35167((class_1308)this, (class_1799)stack);
        class_9279.method_57452((class_9331)class_9334.field_49610, (class_1799)stack, tag -> {
            tag.method_10569("Age", this.method_5618());
            if (this.isSheared()) {
                tag.method_10556("Sheared", this.isSheared());
            }
            if (this.method_18868().method_18896(EnderscapeMemory.RUSTLE_HAIR_REGROWTH_COOLDOWN)) {
                tag.method_10569("HairRegrowthCooldownTicks", ((Integer)this.method_18868().method_18904(EnderscapeMemory.RUSTLE_HAIR_REGROWTH_COOLDOWN).get()).intValue());
            }
        });
    }

    public void method_35170(class_2487 tag) {
        class_5761.method_35168((class_1308)this, (class_2487)tag);
        tag.method_10550("Age").ifPresent(arg_0 -> ((Rustle)this).method_5614(arg_0));
        tag.method_10577("Sheared").ifPresent(this::setSheared);
        tag.method_10550("HairRegrowthCooldownTicks").ifPresent(ticks -> this.method_18868().method_18878(EnderscapeMemory.RUSTLE_HAIR_REGROWTH_COOLDOWN, ticks));
    }

    public boolean method_17326() {
        return super.method_17326() || this.method_6453();
    }

    protected class_4095.class_5303<Rustle> method_28306() {
        return class_4095.method_28311(RustleAI.MEMORY_TYPES, RustleAI.SENSOR_TYPES);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return RustleAI.makeBrain((class_4095<Rustle>)this.method_28306().method_28335(dynamic));
    }

    public class_4095<Rustle> method_18868() {
        return super.method_18868();
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_6113()) {
            this.sleepingAnimationState.method_41324(this.field_6012);
        } else {
            this.sleepingAnimationState.method_41325();
        }
        if (this.method_5805() && this.method_6113() && this.method_37908().method_8510() % (long)(60 + this.method_59922().method_43048(20)) == 0L && this.method_37908().method_8608()) {
            class_243 pos = this.method_19538().method_1019(this.method_5720().method_1021(0.5));
            this.method_37908().method_8406((class_2394)EnderscapeParticles.RUSTLE_SLEEPING_BUBBLE, pos.field_1352, this.method_23318() + (double)this.method_17682() - (double)0.1f, pos.field_1350, 0.0, 0.0, 0.0);
        }
    }

    protected void method_5958(class_3218 level) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("rustleBrain");
        this.method_18868().method_19542(level, (class_1309)this);
        profiler.method_15407();
        profiler.method_15396("rustleActivityUpdate");
        RustleAI.updateActivity(this);
        profiler.method_15407();
        if (this.method_6113()) {
            this.method_18868().method_18904(EnderscapeMemory.RUSTLE_SLEEPING_SPOT).ifPresentOrElse(pos -> {
                if (!level.method_19494().method_19116(pos, type -> type.method_40220(EnderscapePoiTags.RUSTLE_SLEEPING_SPOT))) {
                    this.method_18868().method_18875(EnderscapeMemory.RUSTLE_SLEEPING_SPOT);
                    this.wakeUp();
                }
                if (this.method_5721() || this.method_18798().method_1027() > 0.1 || !level.method_19494().method_19116(this.method_24515(), type -> type.method_40220(EnderscapePoiTags.RUSTLE_SLEEPING_SPOT))) {
                    this.wakeUp();
                }
            }, this::wakeUp);
        }
        this.setSleeping(this.method_18868().method_18896(EnderscapeMemory.RUSTLE_SLEEP_TICKS));
        super.method_5958(level);
    }

    public float method_6144(class_2338 pos, class_4538 level) {
        return level.method_8320(pos.method_10074()).method_26164(EnderscapeBlockTags.RUSTLE_PREFERRED) ? 10.0f : 0.0f;
    }

    public static boolean canSpawn(class_1299<?> type, class_1936 level, class_3730 reason, class_2338 pos, class_5819 random) {
        return level.method_8320(pos.method_10074()).method_26164(EnderscapeBlockTags.RUSTLE_SPAWNABLE_ON);
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 data) {
        if (reason == class_3730.field_16473) {
            return data;
        }
        return super.method_5943(level, difficulty, reason, data);
    }

    public boolean method_6049(class_1293 instance) {
        return !instance.method_55654(class_1294.field_5899) && super.method_6049(instance);
    }

    protected void method_6087(class_1297 entity) {
        long gameTime;
        super.method_6087(entity);
        if (this.method_5854() == null && entity.method_5864() != this.method_5864() && !entity.method_18276() && (gameTime = this.method_37908().method_8510()) - this.lastBumpTimestamp > 20L) {
            this.lastBumpTimestamp = gameTime;
            this.method_5783(EnderscapeEntitySounds.RUSTLE_BUMP, 1.0f, this.method_6017());
            this.method_5942().method_6340();
            if (this.method_6113()) {
                this.wakeUp();
            }
        }
    }

    public boolean method_6453() {
        return (Boolean)this.field_6011.method_12789(FROM_BUCKET);
    }

    public void method_6454(boolean value) {
        this.field_6011.method_12778(FROM_BUCKET, (Object)value);
    }

    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    public void setSleeping(boolean value) {
        this.field_6011.method_12778(SLEEPING, (Object)value);
    }

    public void wakeUp() {
        this.method_18868().method_18875(EnderscapeMemory.RUSTLE_SLEEPING_SPOT);
        this.method_18868().method_18875(EnderscapeMemory.RUSTLE_SLEEP_TICKS);
        this.method_18868().method_24525(EnderscapeMemory.RUSTLE_SLEEPING_ON_COOLDOWN, (Object)true, 100L);
        this.setSleeping(false);
    }

    public boolean isSheared() {
        return (Boolean)this.field_6011.method_12789(SHEARED);
    }

    public void setSheared(boolean value) {
        this.field_6011.method_12778(SHEARED, (Object)value);
    }

    public void method_6636(class_3218 level, class_3419 source, class_1799 stack) {
        this.method_5783(EnderscapeEntitySounds.RUSTLE_SHEAR, 1.0f, 1.0f);
        this.method_64170(level, EnderscapeEntityLootTables.SHEARING_RUSTLE, builder -> builder.method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_1229, (Object)stack).method_51875(class_173.field_49446), (level2, item) -> {
            for (int i = 0; i < item.method_7947(); ++i) {
                class_1542 entity = this.method_5699((class_3218)level2, item.method_46651(1), 0.2f);
                if (entity == null) continue;
                entity.method_18799(entity.method_18798().method_1031((double)class_3532.method_15344((class_5819)this.field_5974, (float)-0.1f, (float)0.1f), (double)class_3532.method_15344((class_5819)this.field_5974, (float)0.0f, (float)0.05f), (double)class_3532.method_15344((class_5819)this.field_5974, (float)-0.1f, (float)0.1f)));
            }
        });
        this.setSheared(true);
        RustleAI.refreshNaturalHairGrowthCooldown(this);
    }

    public boolean method_27072() {
        return this.method_5805() && !this.method_6109() && !this.isSheared();
    }

    public boolean method_64397(class_3218 level, class_1282 source, float amount) {
        boolean result = super.method_64397(level, source, amount);
        if (result && this.method_6113()) {
            this.wakeUp();
        }
        return result;
    }

    public static void regrowHairWithParticles(class_3218 level, Rustle mob) {
        class_243 pos = mob.method_19538();
        level.method_65096((class_2394)class_2398.field_11211, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 5, 0.5, 0.5, 0.5, 0.0);
        mob.setSheared(false);
        RustleAI.refreshNaturalHairGrowthCooldown(mob);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (this.method_6481(stack) && this.method_6113()) {
            return class_1269.field_5811;
        }
        if (this.method_5805()) {
            if (stack.method_7909() == class_1802.field_8550) {
                this.method_5783(this.method_35171(), 1.0f, 1.0f);
                class_1799 bucket = this.method_6452();
                this.method_6455(bucket);
                player.method_6122(hand, class_5328.method_30270((class_1799)stack, (class_1657)player, (class_1799)bucket, (boolean)false));
                if (player instanceof class_3222) {
                    class_3222 server = (class_3222)player;
                    class_174.field_1208.method_8932(server, bucket);
                }
                if (this.method_60953()) {
                    this.method_5932();
                }
                this.method_31472();
                return class_1269.field_5812;
            }
            if (stack.method_7909() instanceof class_1820 && this.method_27072()) {
                class_1937 class_19372 = this.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 server = (class_3218)class_19372;
                    this.method_6636(server, class_3419.field_15248, stack);
                    stack.method_7970(1, (class_1309)player, Rustle.method_56079((class_1268)hand));
                    this.method_32875((class_6880)class_5712.field_28730, (class_1297)player);
                    return class_1269.field_52422;
                }
                return class_1269.field_21466;
            }
        }
        return super.method_5992(player, hand);
    }

    public class_3414 method_35171() {
        return EnderscapeItemSounds.RUSTLE_BUCKET_FILL;
    }

    public class_1799 method_6452() {
        return new class_1799((class_1935)EnderscapeItems.RUSTLE_BUCKET);
    }

    public void method_6091(class_243 vec) {
        if (this.method_6113()) {
            if (this.method_5942().method_6345() != null) {
                this.method_5942().method_6340();
            }
            vec = class_243.field_1353;
        }
        super.method_6091(vec);
    }

    protected class_3414 method_5994() {
        return this.method_6113() ? EnderscapeEntitySounds.RUSTLE_SNORE : EnderscapeEntitySounds.RUSTLE_AMBIENT;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return EnderscapeEntitySounds.RUSTLE_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return EnderscapeEntitySounds.RUSTLE_DEATH;
    }

    protected class_3414 getStepSound() {
        return EnderscapeEntitySounds.RUSTLE_STEP;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(this.getStepSound(), 0.15f, class_3532.method_15344((class_5819)this.field_5974, (float)0.9f, (float)1.1f));
    }

    protected void method_6475(class_1657 player, class_1268 hand, class_1799 stack) {
        super.method_6475(player, hand, stack);
        if (this.method_6481(stack)) {
            this.method_61458();
        }
    }

    protected void method_61458() {
        this.method_37908().method_43129(null, (class_1297)this, EnderscapeEntitySounds.RUSTLE_EAT, this.method_5634(), this.method_6107(), this.method_6017());
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(EnderscapeItemTags.RUSTLE_FOOD);
    }

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 mob) {
        return (class_1296)EnderscapeEntities.RUSTLE.method_5883((class_1937)level, class_3730.field_16466);
    }
}

