/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.sound;

import net.bunten.enderscape.block.state.StateProperties;
import net.bunten.enderscape.registry.EnderscapeRegistries;
import net.bunten.enderscape.sound.MagniaRadioSong;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class MagniaRadioSongPlayer {
    private long ticksSinceSongStarted;
    @Nullable
    private class_6880<MagniaRadioSong> song;
    private final class_2338 pos;
    private final OnSongChanged onChanged;

    public MagniaRadioSongPlayer(OnSongChanged onChanged, class_2338 pos) {
        this.onChanged = onChanged;
        this.pos = pos;
    }

    public boolean isPlaying() {
        return this.song != null;
    }

    @Nullable
    public MagniaRadioSong getSong() {
        return this.song == null ? null : (MagniaRadioSong)this.song.comp_349();
    }

    public long getTicksSinceSongStarted() {
        return this.ticksSinceSongStarted;
    }

    public void setSongWithoutPlaying(class_6880<MagniaRadioSong> holder, long time) {
        if (!((MagniaRadioSong)holder.comp_349()).hasFinished(time)) {
            this.song = holder;
            this.ticksSinceSongStarted = time;
        }
    }

    public void play(class_1936 level, class_6880<MagniaRadioSong> holder) {
        this.song = holder;
        this.ticksSinceSongStarted = 0L;
        int value = level.method_30349().method_30530(EnderscapeRegistries.MAGNIA_RADIO_SONG).method_10206((Object)((MagniaRadioSong)this.song.comp_349()));
        level.method_8444(null, -624642, this.pos, value);
        this.onChanged.notifyChange();
    }

    public void stop(class_1936 level, @Nullable class_2680 state, boolean updateBlock) {
        if (this.song != null) {
            this.song = null;
            this.ticksSinceSongStarted = 0L;
            level.method_43276((class_6880)class_5712.field_39486, this.pos, class_5712.class_7397.method_43287((class_2680)state));
            level.method_20290(-624643, this.pos, 0);
            if (state != null && updateBlock) {
                level.method_8652(this.pos, (class_2680)state.method_11657((class_2769)StateProperties.IS_PLAYING, (Comparable)Boolean.valueOf(false)), 2);
            }
            this.onChanged.notifyChange();
        }
    }

    public void tick(class_1936 level, @Nullable class_2680 state) {
        if (this.song != null) {
            if (((MagniaRadioSong)this.song.comp_349()).hasFinished(this.ticksSinceSongStarted)) {
                this.stop(level, state, true);
            } else {
                if (this.shouldEmitRadioPlayingEvent()) {
                    level.method_43276((class_6880)class_5712.field_39485, this.pos, class_5712.class_7397.method_43287((class_2680)state));
                    MagniaRadioSongPlayer.spawnMusicParticles(level, this.pos);
                }
                ++this.ticksSinceSongStarted;
            }
        }
    }

    private boolean shouldEmitRadioPlayingEvent() {
        return this.ticksSinceSongStarted % 20L == 0L;
    }

    private static void spawnMusicParticles(class_1936 level, class_2338 pos) {
        if (level instanceof class_3218) {
            class_3218 server = (class_3218)level;
            class_243 vec3 = class_243.method_24955((class_2382)pos).method_1031(0.0, (double)1.2f, 0.0);
            float f = (float)level.method_8409().method_43048(4) / 24.0f;
            server.method_65096((class_2394)class_2398.field_11224, vec3.method_10216(), vec3.method_10214(), vec3.method_10215(), 0, (double)f, 0.0, 0.0, 1.0);
        }
    }

    @FunctionalInterface
    public static interface OnSongChanged {
        public void notifyChange();
    }
}

