/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.biome.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.bunten.enderscape.registry.EnderscapeRegistries;
import net.bunten.enderscape.util.RGBA;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public record BiomeParameters(class_2960 location, int nebulaColor, float nebulaAlpha, int starColor, float starAlpha, int flashColor, float fogStartDensity, float fogEndDensity) {
    public static final RGBA DEFAULT_NEBULA_COLOR = new RGBA(8084382, 0.05f);
    public static final RGBA DEFAULT_STAR_COLOR = new RGBA(15305215, 0.12f);
    public static final RGBA DEFAULT_FLASH_COLOR = new RGBA(6638466, 1.0f);
    public static final float DEFAULT_FOG_START_DENSITY = 1.0f;
    public static final float DEFAULT_FOG_END_DENSITY = 1.0f;
    public static final Codec<BiomeParameters> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("biome").forGetter(config -> config.location), (App)Codec.intRange((int)0, (int)0xFFFFFF).fieldOf("nebula_color").forGetter(config -> config.nebulaColor), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("nebula_alpha").forGetter(config -> Float.valueOf(config.nebulaAlpha)), (App)Codec.intRange((int)0, (int)0xFFFFFF).fieldOf("star_color").forGetter(config -> config.starColor), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("star_alpha").forGetter(config -> Float.valueOf(config.starAlpha)), (App)Codec.intRange((int)0, (int)0xFFFFFF).fieldOf("flash_color").forGetter(config -> config.flashColor), (App)Codec.floatRange((float)1.0f, (float)4.0f).fieldOf("fog_start_density").forGetter(config -> Float.valueOf(config.fogStartDensity)), (App)Codec.floatRange((float)1.0f, (float)4.0f).fieldOf("fog_end_density").forGetter(config -> Float.valueOf(config.fogEndDensity))).apply((Applicative)instance, BiomeParameters::new));

    public RGBA nebulaRGBA() {
        return new RGBA(this.nebulaColor, this.nebulaAlpha);
    }

    public RGBA starRGBA() {
        return new RGBA(this.starColor, this.starAlpha);
    }

    public RGBA flashRGBA() {
        return new RGBA(this.flashColor, 1.0f);
    }

    public static Optional<BiomeParameters> findFor(class_6880<class_1959> biomeHolder) {
        if (biomeHolder == null) {
            return Optional.empty();
        }
        class_2378 lookup = class_310.method_1551().field_1687.method_30349().method_30530(EnderscapeRegistries.BIOME_PARAMETERS);
        Optional biomeResourceKey = biomeHolder.method_40230();
        if (biomeResourceKey.isPresent()) {
            BiomeParameters value = (BiomeParameters)lookup.method_10223(((class_5321)biomeResourceKey.get()).method_29177());
            return value != null ? Optional.of(value) : Optional.empty();
        }
        return Optional.empty();
    }
}

