/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import net.bunten.enderscape.block.DirectionalPlantBlock;
import net.bunten.enderscape.block.properties.DirectionSet;
import net.bunten.enderscape.block.state.PartProperty;
import net.bunten.enderscape.block.state.StateProperties;
import net.bunten.enderscape.feature.GrowthConfig;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_6019;

public abstract class AbstractGrowthBlock
extends DirectionalPlantBlock
implements class_2256 {
    public static final class_2754<PartProperty> PART = StateProperties.GROWTH_PART;

    public AbstractGrowthBlock(DirectionSet properties, class_4970.class_2251 settings) {
        super(properties, settings);
        this.method_9590((class_2680)this.method_9564().method_11657(PART, (Comparable)((Object)PartProperty.SINGLE)));
    }

    public static PartProperty getPart(class_2680 state) {
        return (PartProperty)((Object)state.method_11654(PART));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{PART, FACING});
    }

    public boolean hasGrowthSupport(class_2680 state, class_2680 floor) {
        return floor.method_27852((class_2248)this) && floor.method_11654((class_2769)FACING) == state.method_11654((class_2769)FACING);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return BlockUtil.createRotatedShape(1.0, 0.0, 1.0, 15.0, AbstractGrowthBlock.isTopOrSinglePart(state) ? 15.0 : 16.0, 15.0, (class_2350)state.method_11654((class_2769)FACING));
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!state.method_26184((class_4538)world, pos)) {
            world.method_22352(pos, true);
        }
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 state2, class_1936 world, class_2338 pos, class_2338 pos2) {
        class_2350 plantDirection = AbstractGrowthBlock.getFacing(state);
        class_2350 opposite = plantDirection.method_10153();
        if (opposite == direction && !state.method_26184((class_4538)world, pos)) {
            world.method_39279(pos, (class_2248)this, 1);
        }
        class_2680 up = world.method_8320(pos.method_10093(plantDirection));
        class_2680 down = world.method_8320(pos.method_10093(opposite));
        if (down.method_27852((class_2248)this)) {
            return (class_2680)state.method_11657(PART, (Comparable)((Object)(up.method_27852((class_2248)this) && AbstractGrowthBlock.getFacing(up) == plantDirection ? PartProperty.MIDDLE : PartProperty.TOP)));
        }
        return (class_2680)state.method_11657(PART, (Comparable)((Object)(up.method_27852((class_2248)this) && AbstractGrowthBlock.getFacing(up) == plantDirection ? PartProperty.BOTTOM : PartProperty.SINGLE)));
    }

    public boolean method_9651(class_4538 world, class_2338 origin, class_2680 state) {
        return AbstractGrowthBlock.isTopOrSinglePart(state) && world.method_8320(origin.method_10093(AbstractGrowthBlock.getFacing(state))).method_26215();
    }

    private static boolean isTopOrSinglePart(class_2680 state) {
        return AbstractGrowthBlock.getPart(state) == PartProperty.SINGLE || AbstractGrowthBlock.getPart(state) == PartProperty.TOP;
    }

    public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return true;
    }

    public void method_9652(class_3218 world, class_5819 random, class_2338 origin, class_2680 state) {
        world.method_8501(origin.method_10093(AbstractGrowthBlock.getFacing(state)), state);
    }

    public static void generatePatch(class_3218 world, class_5819 random, class_2338 origin, class_2680 state, int range, int i, int max) {
        for (class_2338 pos : class_2338.method_34848((class_5819)random, (int)30, (class_2338)origin, (int)range)) {
            if (i >= max) break;
            class_2350 direction = AbstractGrowthBlock.getFacing(state);
            class_2338 offset = pos.method_10093(direction);
            if (world.method_8320(pos).method_27852(state.method_26204()) || !world.method_22347(offset) || !state.method_26184((class_4538)world, offset)) continue;
            AbstractGrowthBlock.generate((class_1936)world, offset, random, new GrowthConfig(state, (class_6017)class_6016.method_34998((int)1), (class_6017)class_6019.method_35017((int)1, (int)2), 0.5f));
            ++i;
        }
    }

    public static boolean generate(class_1936 world, class_2338 origin, class_5819 random, GrowthConfig config) {
        class_2680 state = config.state();
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        int totalHeight = config.base_height().method_35008(random) + (random.method_43057() <= config.added_height_chance() ? config.added_height().method_35008(random) : 0);
        class_2338.class_2339 mutable = origin.method_25503();
        for (int i = 0; totalHeight > i; ++i) {
            PartProperty part = i == totalHeight - 1 ? (totalHeight == 1 ? PartProperty.SINGLE : PartProperty.TOP) : (i == 0 ? PartProperty.BOTTOM : PartProperty.MIDDLE);
            BlockUtil.replace(world, (class_2338)mutable, (class_2680)state.method_11657(StateProperties.GROWTH_PART, (Comparable)((Object)part)));
            mutable.method_10098(direction);
        }
        return true;
    }
}

