/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.block;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.block.MagniaRadioBlock;
import net.bunten.enderscape.block.state.StateProperties;
import net.bunten.enderscape.registry.EnderscapeBlockEntities;
import net.bunten.enderscape.registry.EnderscapeCriteria;
import net.bunten.enderscape.registry.EnderscapeRegistries;
import net.bunten.enderscape.sound.MagniaRadioSong;
import net.bunten.enderscape.sound.MagniaRadioSongPlayer;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class MagniaRadioBlockEntity
extends class_2586 {
    public static final String MAGNIA_RADIO_SONG_TAG_ID = "MagniaRadioSong";
    public static final String LAST_MAGNIA_RADIO_SONG_TAG_ID = "LastMagniaRadioSong";
    public static final String TICKS_SINCE_SONG_STARTED_TAG_ID = "ticks_since_song_started";
    private Optional<class_6880<MagniaRadioSong>> lastSong = Optional.empty();
    private Optional<class_6880<MagniaRadioSong>> currentSong = Optional.empty();
    private final MagniaRadioSongPlayer player = new MagniaRadioSongPlayer(this::onSongChanged, this.method_11016());

    public MagniaRadioBlockEntity(class_2338 pos, class_2680 state) {
        super(EnderscapeBlockEntities.MAGNIA_RADIO, pos, state);
    }

    public Optional<class_6880<MagniaRadioSong>> getLastSong() {
        return this.lastSong;
    }

    public MagniaRadioSongPlayer getSongPlayer() {
        return this.player;
    }

    public void onSongChanged() {
        this.field_11863.method_8452(this.method_11016(), this.method_11010().method_26204());
        this.method_5431();
    }

    public static void playAmbientSound(class_1937 level, class_2338 pos) {
        level.method_8444(null, -624641, pos, 0);
    }

    public static boolean tryPlaySong(MagniaRadioBlockEntity entity, class_1937 level, class_2338 pos) {
        return MagniaRadioBlockEntity.playSong(entity, level, pos, () -> {
            class_2378 songs = level.method_30349().method_30530(EnderscapeRegistries.MAGNIA_RADIO_SONG);
            Predicate<MagniaRadioSong> biomeFilter = song -> level.method_23753(pos).method_40220(song.permittedBiomes());
            Predicate<MagniaRadioSong> powerFilter = MagniaRadioBlock.isPowered(entity.method_11010()) ? MagniaRadioBlockEntity.getExclusiveFilter(level, pos) : MagniaRadioBlockEntity.getRandomFilter(entity);
            List<MagniaRadioSong> candidates = songs.method_10220().filter(biomeFilter.and(powerFilter)).toList();
            return MagniaRadioBlockEntity.pickSong(candidates, (class_2378<MagniaRadioSong>)songs, level.method_8409());
        });
    }

    private static Predicate<MagniaRadioSong> getExclusiveFilter(class_1937 level, class_2338 pos) {
        return song -> song.exclusiveSignal() == level.method_49804(pos);
    }

    private static Predicate<MagniaRadioSong> getRandomFilter(MagniaRadioBlockEntity entity) {
        return song -> !song.equals(entity.getLastSong().map(class_6880::comp_349).orElse(null));
    }

    private static boolean playSong(MagniaRadioBlockEntity entity, class_1937 level, class_2338 pos, Supplier<Optional<class_6880<MagniaRadioSong>>> songSupplier) {
        class_2680 state = level.method_8320(pos);
        if (state.method_28498((class_2769)StateProperties.IS_PLAYING) && !((Boolean)state.method_11654((class_2769)StateProperties.IS_PLAYING)).booleanValue()) {
            if (!level.method_8608()) {
                Optional<class_6880<MagniaRadioSong>> song = songSupplier.get();
                entity.setSong(song);
                level.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43286(null, (class_2680)state));
                song.ifPresent(holder -> {
                    Optional optional = holder.method_40230();
                    optional.ifPresent(key -> level.method_18456().stream().filter(player -> player.method_37908().method_8597() == level.method_8597() && player.method_5707(pos.method_46558()) < 32.0).filter(class_3222.class::isInstance).map(class_3222.class::cast).forEach(player -> EnderscapeCriteria.HEAR_MAGNIA_RADIO_SONG.trigger((class_3222)player, new class_4208(player.method_37908().method_27983(), player.method_23312()), (class_5321<MagniaRadioSong>)((class_5321)optional.get()))));
                });
            }
            return true;
        }
        return false;
    }

    private static Optional<class_6880<MagniaRadioSong>> pickSong(List<MagniaRadioSong> candidates, class_2378<MagniaRadioSong> songs, class_5819 random) {
        return candidates.isEmpty() ? Optional.empty() : Optional.of(songs.method_47983((Object)candidates.get(random.method_43048(candidates.size()))));
    }

    public static class_1269 tryStopPlaying(class_1937 level, class_2338 pos, @Nullable class_1657 player) {
        class_2680 state = level.method_8320(pos);
        if (state.method_28498((class_2769)StateProperties.IS_PLAYING) && ((Boolean)state.method_11654((class_2769)StateProperties.IS_PLAYING)).booleanValue()) {
            class_2586 class_25862;
            if (!level.method_8608() && (class_25862 = level.method_8321(pos)) instanceof MagniaRadioBlockEntity) {
                MagniaRadioBlockEntity entity = (MagniaRadioBlockEntity)class_25862;
                entity.setSong(Optional.empty());
                level.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)state));
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void setSong(Optional<class_6880<MagniaRadioSong>> song) {
        this.notifySongChanged(song.isPresent());
        if (song.isPresent()) {
            this.player.play((class_1936)this.field_11863, song.get());
            this.lastSong = song;
        } else {
            this.player.stop((class_1936)this.field_11863, this.method_11010(), true);
        }
    }

    private void notifySongChanged(boolean value) {
        if (this.field_11863 != null && this.field_11863.method_8320(this.method_11016()) == this.method_11010()) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)StateProperties.IS_PLAYING, (Comparable)Boolean.valueOf(value)), 2);
            this.field_11863.method_43276((class_6880)class_5712.field_28733, this.method_11016(), class_5712.class_7397.method_43287((class_2680)this.method_11010()));
        }
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, MagniaRadioBlockEntity entity) {
        entity.player.tick((class_1936)level, state);
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        Optional holder;
        super.method_11014(tag, provider);
        if (tag.method_10573(MAGNIA_RADIO_SONG_TAG_ID, 10)) {
            holder = MagniaRadioSong.CODEC.parse((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)tag.method_10562(MAGNIA_RADIO_SONG_TAG_ID)).resultOrPartial(string -> Enderscape.LOGGER.error("Tried to load invalid Magnia Radio Song: '{}'", string));
            if (this.currentSong.isPresent() && this.currentSong.get() == holder.get()) {
                this.player.stop((class_1936)this.field_11863, this.method_11010(), true);
            }
            this.currentSong = Optional.of((class_6880)holder.get());
        }
        if (tag.method_10573(LAST_MAGNIA_RADIO_SONG_TAG_ID, 10)) {
            holder = MagniaRadioSong.CODEC.parse((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), (Object)tag.method_10562(LAST_MAGNIA_RADIO_SONG_TAG_ID)).resultOrPartial(string -> Enderscape.LOGGER.error("Tried to load invalid Magnia Radio Song: '{}'", string));
            this.lastSong = Optional.of((class_6880)holder.get());
        }
        if (tag.method_10545(TICKS_SINCE_SONG_STARTED_TAG_ID)) {
            this.currentSong.ifPresent(song -> this.player.setSongWithoutPlaying((class_6880<MagniaRadioSong>)song, tag.method_10537(TICKS_SINCE_SONG_STARTED_TAG_ID)));
        }
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        this.currentSong.ifPresent(holder -> tag.method_10566(MAGNIA_RADIO_SONG_TAG_ID, (class_2520)MagniaRadioSong.CODEC.encodeStart((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), holder).getOrThrow()));
        this.lastSong.ifPresent(holder -> tag.method_10566(LAST_MAGNIA_RADIO_SONG_TAG_ID, (class_2520)MagniaRadioSong.CODEC.encodeStart((DynamicOps)provider.method_57093((DynamicOps)class_2509.field_11560), holder).getOrThrow()));
        if (this.player.getSong() != null) {
            tag.method_10544(TICKS_SINCE_SONG_STARTED_TAG_ID, this.player.getTicksSinceSongStarted());
        }
    }
}

