/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.datagen;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.entity.rubblemite.RubblemiteVariant;
import net.bunten.enderscape.entity.rubblemite.RubblemiteVariantPredicate;
import net.bunten.enderscape.registry.EnderscapeEntities;
import net.bunten.enderscape.registry.EnderscapeEntityLootTables;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.SimpleFabricLootTableProvider;
import net.minecraft.class_117;
import net.minecraft.class_125;
import net.minecraft.class_1299;
import net.minecraft.class_141;
import net.minecraft.class_173;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2048;
import net.minecraft.class_215;
import net.minecraft.class_219;
import net.minecraft.class_221;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_65;
import net.minecraft.class_7225;
import net.minecraft.class_7376;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7924;
import net.minecraft.class_83;

public class EnderscapeEntityLootProvider
extends SimpleFabricLootTableProvider {
    private final CompletableFuture<class_7225.class_7874> lookup;
    public static final Map<RubblemiteVariant, class_5321<class_52>> RUBBLEMITE_BY_VARIANT = Arrays.stream(RubblemiteVariant.values()).collect(Collectors.toMap(variant -> variant, variant -> class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)Enderscape.id("entities/rubblemite/" + variant.method_15434())), (a, b) -> b, () -> new EnumMap(RubblemiteVariant.class)));

    public EnderscapeEntityLootProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> lookup) {
        super(output, lookup, class_173.field_1173);
        this.lookup = lookup;
    }

    public void method_10399(BiConsumer<class_5321<class_52>, class_52.class_53> consumer) {
        try {
            consumer.accept(this.getLootTable(EnderscapeEntities.DRIFTER), class_52.method_324());
            consumer.accept(this.getLootTable(EnderscapeEntities.DRIFTLET), class_52.method_324());
            consumer.accept(this.getLootTable(EnderscapeEntities.RUBBLEMITE), class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351(class_77.method_411((class_1935)EnderscapeItems.RUBBLE_CHITIN).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)1.0f))).method_438((class_117.class_118)class_125.method_547((class_7225.class_7874)this.lookup.get(), (class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_421(class_219.method_932((float)0.25f))).method_356(class_221.method_939())).method_336(EnderscapeEntityLootProvider.createRubblemiteVariantPool()));
            RUBBLEMITE_BY_VARIANT.forEach((variant, key) -> {
                try {
                    consumer.accept((class_5321<class_52>)key, class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)variant.getDropItem()).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))).method_438((class_117.class_118)class_125.method_547((class_7225.class_7874)this.lookup.get(), (class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))))));
                }
                catch (InterruptedException | ExecutionException exception) {
                    throw new RuntimeException("Error processing Rubblemite variant loot table", exception);
                }
            });
            consumer.accept(this.getLootTable(EnderscapeEntities.RUSTLE), class_52.method_324());
            consumer.accept(EnderscapeEntityLootTables.SHEARING_RUSTLE, class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)class_1802.field_8276).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)1.0f, (float)3.0f))))));
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new RuntimeException("Error processing loot table", exception);
        }
    }

    public static class_55.class_56 createRubblemiteVariantPool() {
        class_65.class_66 builder = class_65.method_386((class_79.class_80[])new class_79.class_80[0]);
        RUBBLEMITE_BY_VARIANT.forEach((variant, lootTableKey) -> builder.method_417(class_83.method_428((class_5321)lootTableKey).method_421(class_215.method_917((class_47.class_50)class_47.class_50.field_935, (class_2048.class_2049)class_2048.class_2049.method_8916().method_43094((class_7376)new RubblemiteVariantPredicate(Optional.ofNullable(variant)))))));
        return class_55.method_347().method_351((class_79.class_80)builder);
    }

    private class_5321<class_52> getLootTable(class_1299<?> type) {
        return type.method_16351();
    }
}

