/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.bunten.enderscape.block.BlisteredMagniaBlock;
import net.bunten.enderscape.block.MagniaBlock;
import net.bunten.enderscape.block.MagniaSproutBlock;
import net.bunten.enderscape.block.state.StateProperties;
import net.bunten.enderscape.feature.MagniaSpikeConfig;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.util.BlockUtil;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5726;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class MagniaSpikeFeature
extends class_3031<MagniaSpikeConfig> {
    public MagniaSpikeFeature(Codec<MagniaSpikeConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<MagniaSpikeConfig> context) {
        MagniaSpikeConfig config = (MagniaSpikeConfig)context.method_33656();
        class_5281 level = context.method_33652();
        class_2338 origin = context.method_33655();
        class_5819 random = context.method_33654();
        if (level.method_8320(origin).method_26215() && this.hasSolidCeiling(level, origin, 1) && BlockUtil.hasTerrainDepth((class_1936)level, origin, config.minimum_terrain_depth(), class_2350.field_11036)) {
            ArrayList placedBlocks = Lists.newArrayList();
            this.generateTower(level, origin, random, placedBlocks, config);
            this.generateSprouts(level, random, placedBlocks, config);
            return true;
        }
        return false;
    }

    private void generateTower(class_5281 level, class_2338 origin, class_5819 random, List<class_2338> placedBlocks, MagniaSpikeConfig config) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                boolean atEdgeX = x == -1 || x == 1;
                boolean atEdgeZ = z == -1 || z == 1;
                int height = this.getPillarHeight(random, x, z, atEdgeX, atEdgeZ, config);
                for (int y = 0; y < height; ++y) {
                    class_2338 currentPos = origin.method_10069(x, -y, z);
                    if (!level.method_16358(currentPos, class_5726::method_33014)) continue;
                    level.method_8652(currentPos, EnderscapeBlocks.REPULSIVE_MAGNIA.method_9564(), 2);
                    placedBlocks.add(currentPos);
                }
            }
        }
    }

    private void generateSprouts(class_5281 level, class_5819 random, List<class_2338> placedBlocks, MagniaSpikeConfig config) {
        for (class_2338 pos : placedBlocks) {
            for (class_2350 direction : class_2350.values()) {
                class_2338 relative;
                class_2680 floor = level.method_8320(pos);
                if (!(floor.method_26204() instanceof MagniaBlock)) continue;
                float chance = config.repulsive_magnia_sprout_placement_chance().method_33920(random);
                if (!(random.method_43057() <= chance) || !level.method_8320(relative = pos.method_10093(direction)).method_45474() || !level.method_8320(pos.method_10079(direction, 2)).method_45474()) continue;
                if (random.method_43048(80) == 0) {
                    class_2680 state = (class_2680)EnderscapeBlocks.BLISTERED_MAGNIA.method_9564().method_11657(StateProperties.OPTIONAL_MAGNIA_POLARITY, (Comparable)((Object)BlisteredMagniaBlock.selectPolarity((class_4538)level, relative)));
                    level.method_8652(relative, state, 2);
                    level.method_39279(relative, state.method_26204(), 1);
                    continue;
                }
                level.method_8652(relative, (class_2680)EnderscapeBlocks.REPULSIVE_MAGNIA_SPROUT.method_9564().method_11657((class_2769)MagniaSproutBlock.FACING, (Comparable)direction), 2);
            }
        }
    }

    private boolean hasSolidCeiling(class_5281 level, class_2338 origin, int radius) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (!level.method_8320(origin.method_10069(x, 1, z)).method_26215()) continue;
                return false;
            }
        }
        return true;
    }

    private int getPillarHeight(class_5819 random, int x, int z, boolean corner, boolean edge, MagniaSpikeConfig config) {
        int height = config.height().method_35008(random);
        if (height <= config.height().method_35011() - 2 && random.method_43048(10) == 0) {
            height *= 2;
        }
        if (corner && edge) {
            height /= class_3532.method_15395((class_5819)random, (int)4, (int)6);
        } else if (x != 0 || z != 0) {
            height /= class_3532.method_15395((class_5819)random, (int)2, (int)4);
            if (random.method_43056()) {
                height += 3;
            }
        }
        return height;
    }
}

