/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.bunten.enderscape.block.BlisteredMagniaBlock;
import net.bunten.enderscape.block.HasMagniaPolarity;
import net.bunten.enderscape.block.MagniaBlock;
import net.bunten.enderscape.block.MagniaSproutBlock;
import net.bunten.enderscape.block.properties.MagniaPolarity;
import net.bunten.enderscape.block.state.StateProperties;
import net.bunten.enderscape.feature.MagniaTowerConfig;
import net.bunten.enderscape.registry.EnderscapeBlocks;
import net.bunten.enderscape.registry.tag.EnderscapeBlockTags;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5726;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class MagniaTowerFeature
extends class_3031<MagniaTowerConfig> {
    public MagniaTowerFeature(Codec<MagniaTowerConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<MagniaTowerConfig> context) {
        MagniaTowerConfig config = (MagniaTowerConfig)context.method_33656();
        class_5281 level = context.method_33652();
        class_2338 origin = context.method_33655();
        class_5819 random = context.method_33654();
        if (level.method_8320(origin).method_26215() && this.hasSolidBase(level, origin, 3)) {
            ArrayList placedBlocks = Lists.newArrayList();
            this.replaceFloor(level, origin, random, placedBlocks, config);
            this.generateTower(level, origin, random, placedBlocks, config);
            this.generateSprouts(level, origin, random, placedBlocks, config);
            return true;
        }
        return false;
    }

    private void replaceFloor(class_5281 level, class_2338 origin, class_5819 random, List<class_2338> placedBlocks, MagniaTowerConfig config) {
        float radius = config.floor_replacement_radius().method_33920(random);
        for (float y = -radius; y <= radius; y += 1.0f) {
            for (float x = -radius; x <= radius; x += 1.0f) {
                for (float z = -radius; z <= radius; z += 1.0f) {
                    class_2338 offset = origin.method_10069((int)x, (int)y, (int)z);
                    float distance = (float)Math.sqrt(x * x + y * y + z * z);
                    if (!(distance <= radius + class_3532.method_15344((class_5819)random, (float)-2.5f, (float)0.5f)) || !level.method_8320(offset).method_26164(EnderscapeBlockTags.MAGNIA_TOWER_REPLACEABLE)) continue;
                    level.method_8652(offset, EnderscapeBlocks.REPULSIVE_MAGNIA.method_9564(), 2);
                    placedBlocks.add(offset);
                }
            }
        }
    }

    private void generateTower(class_5281 level, class_2338 origin, class_5819 random, List<class_2338> placedBlocks, MagniaTowerConfig config) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                boolean atEdgeX = x == -1 || x == 1;
                boolean atEdgeZ = z == -1 || z == 1;
                int height = this.getPillarHeight(random, x, z, atEdgeX, atEdgeZ, config);
                for (int y = 0; y < height; ++y) {
                    class_2338 currentPos = origin.method_10069(x, y, z);
                    if (level.method_16358(currentPos, class_5726::method_33014)) {
                        level.method_8652(currentPos, EnderscapeBlocks.REPULSIVE_MAGNIA.method_9564(), 2);
                        placedBlocks.add(currentPos);
                    }
                    if (x != 0 || z != 0) continue;
                    this.generateSphere(level, origin.method_10086(height), placedBlocks, random, config);
                }
            }
        }
    }

    private void generateSphere(class_5281 level, class_2338 origin, List<class_2338> placedBlocks, class_5819 random, MagniaTowerConfig config) {
        int radius = config.sphere_radius().method_35008(random);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -radius; y <= radius; ++y) {
                    class_2338 spherePos = origin.method_10069(x, y, z);
                    double sizeReduction = y == 2 ? 1.75 : 1.5;
                    double threshold = (double)(radius * radius) / sizeReduction;
                    if (!((double)(x * x + y * y + z * z) <= threshold)) continue;
                    level.method_8652(spherePos, EnderscapeBlocks.ALLURING_MAGNIA.method_9564(), 2);
                    placedBlocks.add(spherePos);
                    if (y != 0) continue;
                    int ringRadius = config.ring_radius().method_35008(random);
                    this.generateRing(level, origin, placedBlocks, ringRadius, 1.5);
                    this.generateRing(level, origin, placedBlocks, (int)((float)ringRadius * 0.65f), 1.7);
                }
            }
        }
    }

    private void generateRing(class_5281 level, class_2338 origin, List<class_2338> placedBlocks, int radius, double thickness) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                class_2338 offset = origin.method_10069(x, 0, z);
                if (x * x + z * z > radius * radius || (double)(x * x + z * z) < (double)(radius * radius) / thickness || !level.method_16358(offset, class_5726::method_33014)) continue;
                level.method_8652(offset, EnderscapeBlocks.ALLURING_MAGNIA.method_9564(), 2);
                placedBlocks.add(offset);
            }
        }
    }

    private void generateSprouts(class_5281 level, class_2338 origin, class_5819 random, List<class_2338> placedBlocks, MagniaTowerConfig config) {
        for (class_2338 pos : placedBlocks) {
            for (class_2350 direction : class_2350.values()) {
                double dz;
                boolean nearCenter;
                class_2338 relative;
                float chance;
                Optional<MagniaPolarity> type;
                class_2680 floor = level.method_8320(pos);
                if (!(floor.method_26204() instanceof MagniaBlock) || (type = HasMagniaPolarity.optional(floor)).isEmpty()) continue;
                float f = chance = type.get() == MagniaPolarity.ALLURING ? config.alluring_magnia_sprout_placement_chance().method_33920(random) : config.repulsive_magnia_sprout_placement_chance().method_33920(random);
                if (!(random.method_43057() <= chance) || !level.method_8320(relative = pos.method_10093(direction)).method_45474() || !level.method_8320(pos.method_10079(direction, 2)).method_45474()) continue;
                double dx = pos.method_10263() - origin.method_10263();
                boolean bl = nearCenter = dx * dx + (dz = (double)(pos.method_10260() - origin.method_10260())) * dz <= 36.0;
                if (random.method_43048(200) == 0 && nearCenter) {
                    class_2680 state = (class_2680)EnderscapeBlocks.BLISTERED_MAGNIA.method_9564().method_11657(StateProperties.OPTIONAL_MAGNIA_POLARITY, (Comparable)((Object)BlisteredMagniaBlock.selectPolarity((class_4538)level, relative)));
                    level.method_8652(relative, state, 2);
                    level.method_39279(relative, state.method_26204(), 1);
                    continue;
                }
                class_2248 sprout = type.get() == MagniaPolarity.ALLURING ? EnderscapeBlocks.ALLURING_MAGNIA_SPROUT : EnderscapeBlocks.REPULSIVE_MAGNIA_SPROUT;
                level.method_8652(relative, (class_2680)sprout.method_9564().method_11657((class_2769)MagniaSproutBlock.FACING, (Comparable)direction), 2);
            }
        }
    }

    private boolean hasSolidBase(class_5281 level, class_2338 origin, int radius) {
        boolean hasSolidGround = false;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (level.method_8320(origin.method_10069(x, -1, z)).method_26215()) {
                    return false;
                }
                hasSolidGround = true;
            }
        }
        return hasSolidGround;
    }

    private int getPillarHeight(class_5819 random, int x, int z, boolean corner, boolean edge, MagniaTowerConfig config) {
        int height = config.pillar_height().method_35008(random);
        if (height <= config.pillar_height().method_35011() - 2 && random.method_43048(10) == 0) {
            height *= 2;
        }
        if (corner && edge) {
            height /= class_3532.method_15395((class_5819)random, (int)4, (int)6);
        } else if (x != 0 || z != 0) {
            height /= class_3532.method_15395((class_5819)random, (int)2, (int)4);
            if (random.method_43056()) {
                height += 3;
            }
        }
        return height;
    }
}

